/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class JerrycanRefillRecipe
extends CustomRecipe {
    private final int jerrycanIndex = 0;
    private final int containerIndex = 1;

    public JerrycanRefillRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@Nonnull CraftingContainer inv, Level world) {
        ItemStack[] components = this.getComponents((Container)inv);
        if (!components[0].isEmpty() && !components[1].isEmpty() && this.countOccupiedSlots((Container)inv) == 2) {
            return FluidUtil.getFluidContained((ItemStack)components[0]).map(fs -> {
                IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)components[1]).orElseThrow(RuntimeException::new);
                FluidStack containerFluid = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                return containerFluid.getAmount() < handler.getTankCapacity(0) && handler.isFluidValid(0, fs);
            }).orElse(false);
        }
        return false;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, RegistryAccess access) {
        ItemStack[] components = this.getComponents((Container)inv);
        ItemStack newContainer = ItemHandlerHelper.copyStackWithSize((ItemStack)components[1], (int)1);
        IFluidHandlerItem handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)newContainer).orElseThrow(RuntimeException::new);
        FluidUtil.getFluidContained((ItemStack)components[0]).ifPresent(fs -> ItemNBTHelper.putInt(components[0], "jerrycanDrain", handler.fill(fs, IFluidHandler.FluidAction.EXECUTE)));
        newContainer = handler.getContainer();
        return newContainer;
    }

    private ItemStack[] getComponents(Container inv) {
        ItemStack[] ret = new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY};
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (ret[0].isEmpty() && stackInSlot.is(IEItems.Misc.JERRYCAN.asItem()) && FluidUtil.getFluidContained((ItemStack)stackInSlot).map(fs -> !fs.isEmpty()).orElse(false).booleanValue()) {
                ret[0] = stackInSlot;
                continue;
            }
            if (ret[1].isEmpty() && FluidUtil.getFluidHandler((ItemStack)stackInSlot).isPresent()) {
                ret[1] = stackInSlot;
                continue;
            }
            return ret;
        }
        return ret;
    }

    private int countOccupiedSlots(Container inv) {
        int c = 0;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (inv.getItem(i).isEmpty()) continue;
            ++c;
        }
        return c;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = super.getRemainingItems((Container)inv);
        boolean foundJerrycan = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.is(IEItems.Misc.JERRYCAN.asItem()) && !foundJerrycan) {
                foundJerrycan = true;
                continue;
            }
            remaining.set(i, (Object)ItemStack.EMPTY);
        }
        return remaining;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.JERRYCAN_REFILL.get();
    }
}

