/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class MetalPressPackingRecipes {
    public static final CachedRecipeList<CraftingRecipe> CRAFTING_RECIPE_MAP = new CachedRecipeList<CraftingRecipe>(() -> RecipeType.CRAFTING, CraftingRecipe.class);
    public static final ResourceLocation UNPACK_ID = ImmersiveEngineering.rl("unpacking");
    public static final ResourceLocation PACK4_ID = ImmersiveEngineering.rl("packing4");
    public static final ResourceLocation PACK9_ID = ImmersiveEngineering.rl("packing9");
    private static final HashMap<ComparableItemStack, RecipeHolder<MetalPressRecipe>> UNPACKING_CACHE = new HashMap();

    public static void init() {
        MetalPressRecipe.addSpecialRecipe(IEApi.ieLoc("metalpress/packing2x2"), new MetalPressPackingRecipe(IEItems.Molds.MOLD_PACKING_4.asItem(), 2));
        MetalPressRecipe.addSpecialRecipe(IEApi.ieLoc("metalpress/packing3x3"), new MetalPressPackingRecipe(IEItems.Molds.MOLD_PACKING_9.asItem(), 3));
        MetalPressRecipe.addSpecialRecipe(IEApi.ieLoc("metalpress/unpacking"), new MetalPressContainerRecipe(IEItems.Molds.MOLD_UNPACKING.asItem()){

            @Override
            protected RecipeHolder<MetalPressRecipe> getRecipeFunction(ItemStack input, Level world) {
                return MetalPressPackingRecipes.getUnpackingCached(input, world);
            }
        });
    }

    @Nullable
    public static RecipeHolder<MetalPressRecipe> getRecipeDelegate(RecipeHolder<CraftingRecipe> recipeHolder, ResourceLocation id, RegistryAccess access) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        NonNullList ingredients = recipe.getIngredients();
        if (ingredients.isEmpty() || ((Ingredient)ingredients.get(0)).isEmpty()) {
            return null;
        }
        ItemStack input = ((Ingredient)ingredients.get(0)).getItems()[0];
        if (PACK4_ID.equals((Object)id)) {
            if (ingredients.size() == 4) {
                return RecipeDelegate.getPacking((Pair<RecipeHolder<CraftingRecipe>, ItemStack>)Pair.of(recipeHolder, (Object)recipe.getResultItem(access)), input, false);
            }
        } else if (PACK9_ID.equals((Object)id)) {
            if (ingredients.size() == 9) {
                return RecipeDelegate.getPacking((Pair<RecipeHolder<CraftingRecipe>, ItemStack>)Pair.of(recipeHolder, (Object)recipe.getResultItem(access)), input, true);
            }
        } else if (UNPACK_ID.equals((Object)id) && ingredients.size() == 1) {
            return RecipeDelegate.getUnpacking((Pair<RecipeHolder<CraftingRecipe>, ItemStack>)Pair.of(recipeHolder, (Object)recipe.getResultItem(access)), input);
        }
        return null;
    }

    public static Pair<RecipeHolder<CraftingRecipe>, ItemStack> getPackedOutput(int gridSize, ItemStack stack, Level world) {
        CraftingContainer invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(gridSize, gridSize, (List<ItemStack>)NonNullList.withSize((int)(gridSize * gridSize), (Object)stack.copy()));
        return world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)invC, world).map(recipe -> Pair.of((Object)recipe, (Object)((CraftingRecipe)recipe.value()).assemble((Container)invC, world.registryAccess()))).orElse(null);
    }

    private static RecipeHolder<MetalPressRecipe> getUnpackingCached(ItemStack input, Level world) {
        ComparableItemStack comp = new ComparableItemStack(input, false);
        if (UNPACKING_CACHE.containsKey(comp)) {
            return UNPACKING_CACHE.get(comp);
        }
        comp.copy();
        Pair<RecipeHolder<CraftingRecipe>, ItemStack> out = MetalPressPackingRecipes.getPackedOutput(1, input, world);
        if (out == null) {
            return null;
        }
        ItemStack outStack = (ItemStack)out.getSecond();
        int count = outStack.getCount();
        if (count != 4 && count != 9) {
            UNPACKING_CACHE.put(comp, null);
            return null;
        }
        Pair<RecipeHolder<CraftingRecipe>, ItemStack> rePacked = MetalPressPackingRecipes.getPackedOutput(count == 4 ? 2 : 3, outStack, world);
        ItemStack singleInput = ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)1);
        if (rePacked == null || ((ItemStack)rePacked.getSecond()).isEmpty() || !ItemStack.matches((ItemStack)singleInput, (ItemStack)((ItemStack)rePacked.getSecond()))) {
            UNPACKING_CACHE.put(comp, null);
            return null;
        }
        RecipeHolder<MetalPressRecipe> delegate = RecipeDelegate.getUnpacking(out, singleInput);
        UNPACKING_CACHE.put(comp, delegate);
        return delegate;
    }

    public static class MetalPressPackingRecipe
    extends MetalPressContainerRecipe {
        private final int size;
        private final Map<ComparableItemStack, RecipeHolder<MetalPressRecipe>> PACKING_CACHE = new HashMap<ComparableItemStack, RecipeHolder<MetalPressRecipe>>();

        public MetalPressPackingRecipe(Item mold, int size) {
            super(mold);
            this.size = size;
        }

        @Override
        public boolean matches(ItemStack mold, ItemStack input, Level world) {
            return input.getCount() >= this.size * this.size && super.matches(mold, input, world);
        }

        @Override
        protected RecipeHolder<MetalPressRecipe> getRecipeFunction(ItemStack input, Level world) {
            ComparableItemStack comp = new ComparableItemStack(input, false);
            if (this.PACKING_CACHE.containsKey(comp)) {
                return this.PACKING_CACHE.get(comp);
            }
            int totalSize = this.size * this.size;
            comp.copy();
            Pair<RecipeHolder<CraftingRecipe>, ItemStack> out = MetalPressPackingRecipes.getPackedOutput(this.size, input, world);
            if (out == null) {
                return null;
            }
            ItemStack outStack = (ItemStack)out.getSecond();
            if (outStack.isEmpty()) {
                this.PACKING_CACHE.put(comp, null);
                return null;
            }
            RecipeHolder<MetalPressRecipe> delegate = RecipeDelegate.getPacking(out, ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)totalSize), this.size == 3);
            this.PACKING_CACHE.put(comp, delegate);
            return delegate;
        }
    }

    public static class RecipeDelegate
    extends MetalPressRecipe {
        public final RecipeHolder<CraftingRecipe> baseRecipe;

        private RecipeDelegate(ItemStack output, ItemStack input, Item mold, RecipeHolder<CraftingRecipe> baseRecipe) {
            super(new TagOutput(output), IngredientWithSize.of(input), mold, 3200);
            this.baseRecipe = baseRecipe;
        }

        public static RecipeHolder<MetalPressRecipe> getPacking(Pair<RecipeHolder<CraftingRecipe>, ItemStack> originalRecipe, ItemStack input, boolean big) {
            ItemStack output = (ItemStack)originalRecipe.getSecond();
            input = ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)(big ? 9 : 4));
            return new RecipeHolder(big ? PACK9_ID : PACK4_ID, (Recipe)new RecipeDelegate(output, input, (Item)(big ? IEItems.Molds.MOLD_PACKING_9 : IEItems.Molds.MOLD_PACKING_4).get(), (RecipeHolder<CraftingRecipe>)((RecipeHolder)originalRecipe.getFirst())));
        }

        public static RecipeHolder<MetalPressRecipe> getUnpacking(Pair<RecipeHolder<CraftingRecipe>, ItemStack> originalRecipe, ItemStack input) {
            ItemStack output = (ItemStack)originalRecipe.getSecond();
            return new RecipeHolder(UNPACK_ID, (Recipe)new RecipeDelegate(output, input, (Item)IEItems.Molds.MOLD_UNPACKING.get(), (RecipeHolder<CraftingRecipe>)((RecipeHolder)originalRecipe.getFirst())));
        }

        @Override
        public boolean listInJEI() {
            return false;
        }
    }

    public static abstract class MetalPressContainerRecipe
    extends MetalPressRecipe {
        public MetalPressContainerRecipe(Item mold) {
            super(TagOutput.EMPTY, new IngredientWithSize(Ingredient.EMPTY), mold, 3200);
        }

        @Override
        public boolean listInJEI() {
            return false;
        }

        @Override
        public boolean matches(ItemStack mold, ItemStack input, Level world) {
            return this.getRecipeFunction(input, world) != null;
        }

        @Override
        public RecipeHolder<MetalPressRecipe> getActualRecipe(ResourceLocation ownId, ItemStack mold, ItemStack input, Level world) {
            return this.getRecipeFunction(input, world);
        }

        protected abstract RecipeHolder<MetalPressRecipe> getRecipeFunction(ItemStack var1, Level var2);
    }
}

