/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PotionBulletFillRecipe
extends CustomRecipe {
    public PotionBulletFillRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        boolean hasBullet = false;
        boolean hasPotion = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (this.isPotionBullet(stackInSlot)) {
                if (hasBullet) {
                    return false;
                }
                hasBullet = true;
                continue;
            }
            if (stackInSlot.getItem() instanceof PotionItem) {
                if (hasPotion) {
                    return false;
                }
                hasPotion = true;
                continue;
            }
            return false;
        }
        return hasBullet && hasPotion;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack bullet = ItemStack.EMPTY;
        ItemStack potion = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (bullet.isEmpty() && this.isPotionBullet(stackInSlot)) {
                bullet = stackInSlot;
                continue;
            }
            if (!potion.isEmpty() || !(stackInSlot.getItem() instanceof PotionItem)) continue;
            potion = stackInSlot;
        }
        ItemStack newBullet = ItemHandlerHelper.copyStackWithSize((ItemStack)bullet, (int)1);
        ItemNBTHelper.setItemStack(newBullet, "potion", potion.copy());
        return newBullet;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.POTION_BULLET_FILL.get();
    }

    private boolean isPotionBullet(ItemStack stack) {
        return stack.getItem() instanceof BulletItem && ((BulletItem)stack.getItem()).getType() == BulletHandler.getBullet(BulletItem.POTION);
    }
}

