/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.mixin.accessors.PotionBrewingAccess;
import blusunrize.immersiveengineering.mixin.accessors.PotionMixAccessor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.BrewingRecipeRegistry;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;

public class PotionHelper {
    public static FluidTagInput getFluidTagForType(Potion type, int amount) {
        if (type == Potions.WATER || type == null) {
            return new FluidTagInput((TagKey<Fluid>)FluidTags.WATER, amount);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putString("Potion", BuiltInRegistries.POTION.getKey((Object)type).toString());
        return new FluidTagInput(IETags.fluidPotion, amount, nbt);
    }

    public static void applyToAllPotionRecipes(PotionRecipeProcessor out) {
        for (PotionBrewing.Mix<Potion> mixPredicate : PotionBrewingAccess.getConversions()) {
            out.apply((Potion)mixPredicate.to, (Potion)mixPredicate.from, new IngredientWithSize(((PotionMixAccessor)mixPredicate).getIngredient()));
        }
        for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(recipe instanceof BrewingRecipe)) continue;
            IngredientWithSize ingredient = new IngredientWithSize(((BrewingRecipe)recipe).getIngredient());
            Ingredient input = ((BrewingRecipe)recipe).getInput();
            ItemStack output = ((BrewingRecipe)recipe).getOutput();
            if (output.getItem() != Items.POTION || input.getItems().length <= 0) continue;
            out.apply(PotionUtils.getPotion((ItemStack)output), PotionUtils.getPotion((ItemStack)input.getItems()[0]), ingredient);
        }
    }

    public static interface PotionRecipeProcessor {
        public void apply(Potion var1, Potion var2, IngredientWithSize var3);
    }
}

