/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.crafting.PotionHelper;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PotionRecipeGenerators {
    public static final Set<String> BLACKLIST = new HashSet<String>();

    public static List<MixerRecipe> initPotionRecipes() {
        HashMap recipes = new HashMap();
        PotionHelper.applyToAllPotionRecipes((out, in, reagent) -> PotionRecipeGenerators.registerPotionRecipe(out, in, reagent, recipes));
        return recipes.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<BottlingMachineRecipe> getPotionBottlingRecipes() {
        HashMap<Potion, BottlingMachineRecipe> bottleRecipes = new HashMap<Potion, BottlingMachineRecipe>();
        Function<Potion, BottlingMachineRecipe> toBottleRecipe = potion -> new BottlingMachineRecipe(new TagOutputList(new TagOutput(PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)potion))), IngredientWithSize.of(new ItemStack((ItemLike)Items.GLASS_BOTTLE)), PotionHelper.getFluidTagForType(potion, 250));
        HashMap bulletRecipes = new HashMap();
        Function<Potion, BottlingMachineRecipe> toBulletRecipe = potion -> {
            ItemStack bulletStack = BulletHandler.getBulletStack(BulletItem.POTION);
            ItemNBTHelper.setItemStack(bulletStack, "potion", PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)potion));
            return new BottlingMachineRecipe(new TagOutputList(new TagOutput(bulletStack)), new IngredientWithSize(Ingredient.of((ItemLike[])new ItemLike[]{BulletHandler.getBulletItem(BulletItem.POTION)})), PotionHelper.getFluidTagForType(potion, 250));
        };
        PotionHelper.applyToAllPotionRecipes((out, in, reagent) -> {
            if (!bottleRecipes.containsKey(out)) {
                bottleRecipes.put(out, (BottlingMachineRecipe)toBottleRecipe.apply(out));
            }
            if (!bulletRecipes.containsKey(out)) {
                bulletRecipes.put(out, (BottlingMachineRecipe)toBulletRecipe.apply(out));
            }
        });
        bottleRecipes.put(Potions.WATER, toBottleRecipe.apply(Potions.WATER));
        IELogger.logger.info("Recipes for potions: " + bottleRecipes.keySet().stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.POTION).getKey(arg_0)).map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        ArrayList<BottlingMachineRecipe> ret = new ArrayList<BottlingMachineRecipe>(bottleRecipes.values());
        ret.addAll(bulletRecipes.values());
        return ret;
    }

    public static void registerPotionRecipe(Potion output, Potion input, IngredientWithSize reagent, Map<Potion, List<MixerRecipe>> all) {
        ResourceLocation outputID = BuiltInRegistries.POTION.getKey((Object)output);
        if (!BLACKLIST.contains(outputID.toString())) {
            List existing = all.computeIfAbsent(output, p -> new ArrayList());
            MixerRecipe recipe = new MixerRecipe(PotionFluid.getFluidStackForType(output, 1000), PotionHelper.getFluidTagForType(input, 1000), List.of(reagent), 6400);
            existing.add(recipe);
        }
    }
}

