/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PowerpackRecipe
implements CraftingRecipe {
    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        ItemStack powerpack = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (powerpack.isEmpty() && stackInSlot.is(IEItems.Misc.POWERPACK.asItem())) {
                powerpack = stackInSlot;
                continue;
            }
            if (armor.isEmpty() && this.isValidArmor(stackInSlot)) {
                armor = stackInSlot;
                continue;
            }
            return false;
        }
        if (!(powerpack.isEmpty() || armor.isEmpty() || ItemNBTHelper.hasKey(armor, "IE:Powerpack"))) {
            return true;
        }
        return !armor.isEmpty() && ItemNBTHelper.hasKey(armor, "IE:Powerpack") && powerpack.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack powerpack = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (powerpack.isEmpty() && stackInSlot.is(IEItems.Misc.POWERPACK.asItem())) {
                powerpack = stackInSlot;
                continue;
            }
            if (!armor.isEmpty() || !this.isValidArmor(stackInSlot)) continue;
            armor = stackInSlot;
        }
        if (!(powerpack.isEmpty() || armor.isEmpty() || ItemNBTHelper.hasKey(armor, "IE:Powerpack"))) {
            ItemStack output = armor.copy();
            ItemNBTHelper.setItemStack(output, "IE:Powerpack", ItemHandlerHelper.copyStackWithSize((ItemStack)powerpack, (int)1));
            return output;
        }
        if (!armor.isEmpty() && ItemNBTHelper.hasKey(armor, "IE:Powerpack")) {
            ItemStack output = armor.copy();
            ItemNBTHelper.remove(output, "IE:Powerpack");
            return output;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess access) {
        return new ItemStack(IEItems.Misc.POWERPACK, 1);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = super.getRemainingItems((Container)inv);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty() || !ItemNBTHelper.hasKey(stackInSlot, "IE:Powerpack")) continue;
            remaining.set(i, (Object)ItemNBTHelper.getItemStack(stackInSlot, "IE:Powerpack"));
        }
        return remaining;
    }

    private boolean isValidArmor(ItemStack stack) {
        ArmorItem armor;
        Item item = stack.getItem();
        if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).getEquipmentSlot() != EquipmentSlot.CHEST) {
            return false;
        }
        if (stack.getItem() == IEItems.Misc.POWERPACK.asItem()) {
            return false;
        }
        return !stack.is(IETags.powerpackForbidAttach);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.POWERPACK_SERIALIZER.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.withSize((int)1, (Object)Ingredient.of((ItemLike[])new ItemLike[]{IEItems.Misc.POWERPACK}));
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }
}

