/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class RGBColourationRecipe
implements CraftingRecipe {
    private final Ingredient target;
    private final String colorKey;

    public RGBColourationRecipe(Ingredient target, String colorKey) {
        this.target = target;
        this.colorKey = colorKey;
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        ItemStack itemToColour = ItemStack.EMPTY;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (itemToColour.isEmpty() && this.target.test(stackInSlot)) {
                itemToColour = stackInSlot;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                list.add(stackInSlot);
                continue;
            }
            return false;
        }
        return !itemToColour.isEmpty() && !list.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        int[] colourArray = new int[3];
        int j = 0;
        int totalColourSets = 0;
        ItemStack itemToColour = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (itemToColour.isEmpty() && this.target.test(stackInSlot)) {
                itemToColour = stackInSlot;
                int colour = itemToColour.hasTag() && itemToColour.getOrCreateTag().contains(this.colorKey, 3) ? itemToColour.getOrCreateTag().getInt(this.colorKey) : 0xFFFFFF;
                float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                float b = (float)(colour & 0xFF) / 255.0f;
                j = (int)((float)j + Math.max(r, Math.max(g, b)) * 255.0f);
                colourArray[0] = (int)((float)colourArray[0] + r * 255.0f);
                colourArray[1] = (int)((float)colourArray[1] + g * 255.0f);
                colourArray[2] = (int)((float)colourArray[2] + b * 255.0f);
                ++totalColourSets;
                continue;
            }
            if (!Utils.isDye(stackInSlot)) continue;
            float[] afloat = Utils.getDye(stackInSlot).getTextureDiffuseColors();
            int r = (int)(afloat[0] * 255.0f);
            int g = (int)(afloat[1] * 255.0f);
            int b = (int)(afloat[2] * 255.0f);
            j += Math.max(r, Math.max(g, b));
            colourArray[0] = colourArray[0] + r;
            colourArray[1] = colourArray[1] + g;
            colourArray[2] = colourArray[2] + b;
            ++totalColourSets;
        }
        if (!itemToColour.isEmpty()) {
            ItemStack newItem = ItemHandlerHelper.copyStackWithSize((ItemStack)itemToColour, (int)1);
            int r = colourArray[0] / totalColourSets;
            int g = colourArray[1] / totalColourSets;
            int b = colourArray[2] / totalColourSets;
            float colourMod = (float)j / (float)totalColourSets;
            float highestColour = Math.max(r, Math.max(g, b));
            r = (int)((float)r * colourMod / highestColour);
            g = (int)((float)g * colourMod / highestColour);
            b = (int)((float)b * colourMod / highestColour);
            int newColour = (r << 8) + g;
            newColour = (newColour << 8) + b;
            newItem.getOrCreateTag().putInt(this.colorKey, newColour);
            return newItem;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.RGB_SERIALIZER.get();
    }

    public Ingredient getTarget() {
        return this.target;
    }

    public String getColorKey() {
        return this.colorKey;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }
}

