/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.crafting.fluidaware.TurnAndCopyRecipe;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class RevolverAssemblyRecipe
extends TurnAndCopyRecipe {
    public RevolverAssemblyRecipe(ShapedRecipe vanilla, List<Integer> copyNBT) {
        super(vanilla, copyNBT);
    }

    @Override
    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.REVOLVER_ASSEMBLY_SERIALIZER.get();
    }

    @Override
    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer matrix, RegistryAccess access) {
        if (this.nbtCopyTargetSlot != null) {
            ItemStack out = this.getResultItem(access).copy();
            CompoundTag tag = new CompoundTag();
            Iterator iterator = this.nbtCopyTargetSlot.iterator();
            while (iterator.hasNext()) {
                int targetSlot = (Integer)iterator.next();
                ItemStack s = matrix.getItem(targetSlot);
                if (s.isEmpty() || !s.hasTag()) continue;
                CompoundTag perks = ItemNBTHelper.getTagCompound(s, "perks");
                for (String key : perks.getAllKeys()) {
                    if (perks.getTagType(key) != 6) continue;
                    RevolverItem.RevolverPerk perk = RevolverItem.RevolverPerk.get(key);
                    if (!tag.contains(key)) {
                        tag.putDouble(key, perks.getDouble(key));
                        continue;
                    }
                    tag.putDouble(key, perk.concat(tag.getDouble(key), perks.getDouble(key)));
                }
            }
            if (!tag.isEmpty()) {
                ItemNBTHelper.setTagCompound(out, "perks", tag);
            }
            return out;
        }
        return super.assemble(matrix, access);
    }
}

