/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class RevolverCycleRecipe
extends CustomRecipe {
    public RevolverCycleRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        ItemStack revolver = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (revolver.isEmpty() && stackInSlot.getItem() == IEItems.Weapons.REVOLVER.asItem()) {
                revolver = stackInSlot;
                continue;
            }
            return false;
        }
        return !revolver.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack revolver = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (revolver.isEmpty() && stackInSlot.getItem() == IEItems.Weapons.REVOLVER.asItem()) {
                revolver = stackInSlot.copy();
                continue;
            }
            return ItemStack.EMPTY;
        }
        return revolver;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.REVOLVER_CYCLE_SERIALIZER.get();
    }
}

