/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class SpeedloaderLoadRecipe
extends CustomRecipe {
    private final byte[] offsetPattern = new byte[]{0, 1, 1, 1, 0, -1, -1, -1};

    public SpeedloaderLoadRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        ItemStack stackInSlot;
        int i;
        int speedloaderX = -1;
        int speedloaderY = -1;
        boolean hasSpeedloader = false;
        NonNullList<ItemStack> speedloaderBullets = null;
        boolean hasBullets = false;
        int width = inv.getWidth();
        for (i = 0; i < inv.getContainerSize(); ++i) {
            stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.getItem() instanceof SpeedloaderItem) {
                if (hasSpeedloader) {
                    return false;
                }
                if (!((SpeedloaderItem)stackInSlot.getItem()).isEmpty(stackInSlot)) {
                    speedloaderBullets = ((SpeedloaderItem)stackInSlot.getItem()).getBullets(stackInSlot);
                }
                speedloaderX = i % width;
                speedloaderY = i / width;
                hasSpeedloader = true;
                continue;
            }
            if (stackInSlot.getItem() instanceof BulletItem) {
                hasBullets = true;
                continue;
            }
            return false;
        }
        if (hasSpeedloader && hasBullets) {
            for (i = 0; i < inv.getContainerSize(); ++i) {
                stackInSlot = inv.getItem(i);
                if (stackInSlot.isEmpty()) continue;
                int curOffsetY = i / width - speedloaderY;
                int curOffsetX = i % width - speedloaderX;
                if (curOffsetY == 0 && curOffsetX == 0 || Math.abs(curOffsetY) <= 1 && Math.abs(curOffsetX) <= 1 && (speedloaderBullets == null || ((ItemStack)speedloaderBullets.get(3 + (curOffsetX > 0 || curOffsetX == 0 && curOffsetY < 0 ? 1 : -1) * (curOffsetX + curOffsetY - 2))).isEmpty())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack speedloader = null;
        int speedloaderX = -1;
        int speedloaderY = -1;
        int width = inv.getWidth();
        int height = inv.getHeight();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (!(inv.getItem(i).getItem() instanceof SpeedloaderItem)) continue;
            speedloader = inv.getItem(i);
            speedloaderX = i % width;
            speedloaderY = i / width;
            break;
        }
        ItemStack out = speedloader.copy();
        NonNullList<ItemStack> fill = ((SpeedloaderItem)out.getItem()).getBullets(out);
        for (int i = 0; i < 8; ++i) {
            ItemStack curBullet;
            int curX;
            int curY = speedloaderY + this.offsetPattern[(i + 6) % 8];
            if (curY < 0 || curY >= height || (curX = speedloaderX + this.offsetPattern[i]) < 0 || curX >= width || (curBullet = inv.getItem(width * curY + curX)).isEmpty()) continue;
            fill.set(i, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)curBullet, (int)1));
        }
        ((SpeedloaderItem)out.getItem()).setContainedItems(out, fill);
        return out;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.SPEEDLOADER_LOAD.get();
    }
}

