/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.IngredientFluidStack;
import blusunrize.immersiveengineering.common.util.IELogger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public abstract class AbstractFluidAwareRecipe<MatchLocation extends IMatchLocation>
implements CraftingRecipe {
    protected static final boolean[] BOOLEANS = new boolean[]{true, false};
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final String group;

    public AbstractFluidAwareRecipe(String groupIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        this.group = groupIn;
        this.recipeItems = recipeItemsIn;
        this.recipeOutput = recipeOutputIn;
    }

    @Nonnull
    public String getGroup() {
        return this.group;
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess access) {
        return this.recipeOutput;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        return this.findMatch(inv) != null;
    }

    @Nullable
    protected abstract MatchLocation findMatch(CraftingContainer var1);

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, RegistryAccess access) {
        return this.getResultItem(access).copy();
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer inv) {
        NonNullList remaining = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        MatchLocation offset = this.findMatch(inv);
        if (offset == null) {
            IELogger.logger.error("IRecipe#getRemainingItems was called with an inventory that does not match the recipe");
            IELogger.logger.error("according to IRecipe#matches. This is probably a bug in some mod in the following stacktrace,");
            IELogger.logger.error("if in doubt report it to Immersive Engineering", (Throwable)new IllegalArgumentException());
            return super.getRemainingItems((Container)inv);
        }
        for (int x = 0; x < inv.getWidth(); ++x) {
            for (int y = 0; y < inv.getHeight(); ++y) {
                int invIndex = this.getInventoryIndex(inv, x, y);
                int ingrIndex = offset.getListIndex(x, y);
                if (ingrIndex < 0 || ingrIndex >= this.getIngredients().size()) continue;
                Ingredient ingr = (Ingredient)this.getIngredients().get(ingrIndex);
                ItemStack item = inv.getItem(invIndex);
                ItemStack result = ItemStack.EMPTY;
                if (ingr instanceof IngredientFluidStack) {
                    IngredientFluidStack fluidIngred = (IngredientFluidStack)ingr;
                    result = fluidIngred.getExtractedStack(item.copy());
                } else if (item.hasCraftingRemainingItem()) {
                    result = item.getCraftingRemainingItem();
                }
                if (result == item) {
                    result = result.copy();
                }
                remaining.set(invIndex, (Object)result);
            }
        }
        return remaining;
    }

    private int getInventoryIndex(CraftingContainer inv, int x, int y) {
        return x + y * inv.getWidth();
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public static interface IMatchLocation {
        public int getListIndex(int var1, int var2);
    }
}

