/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractFluidAwareRecipe;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.crafting.IShapedRecipe;

public abstract class AbstractShapedRecipe<MatchLocation extends AbstractFluidAwareRecipe.IMatchLocation>
extends AbstractFluidAwareRecipe<MatchLocation>
implements IShapedRecipe<CraftingContainer> {
    private final int recipeWidth;
    private final int recipeHeight;
    private final CraftingBookCategory category;
    private final Optional<ShapedRecipePattern.Data> data;

    public AbstractShapedRecipe(String groupIn, int recipeWidth, int recipeHeight, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, CraftingBookCategory category) {
        this(groupIn, recipeWidth, recipeHeight, recipeItemsIn, recipeOutputIn, category, Optional.empty());
    }

    public AbstractShapedRecipe(String groupIn, int recipeWidth, int recipeHeight, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, CraftingBookCategory category, Optional<ShapedRecipePattern.Data> data) {
        super(groupIn, recipeItemsIn, recipeOutputIn);
        this.recipeWidth = recipeWidth;
        this.recipeHeight = recipeHeight;
        this.category = category;
        this.data = data;
    }

    public int getWidth() {
        return this.recipeWidth;
    }

    public int getHeight() {
        return this.recipeHeight;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.IE_SHAPED_SERIALIZER.get();
    }

    public ShapedRecipe toVanilla() {
        return new ShapedRecipe(this.getGroup(), this.category, new ShapedRecipePattern(this.getWidth(), this.getHeight(), this.getIngredients(), this.data), this.getResultItem(null));
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    public int getRecipeWidth() {
        return this.recipeWidth;
    }

    public int getRecipeHeight() {
        return this.recipeHeight;
    }

    public boolean isIncomplete() {
        NonNullList<Ingredient> nonnulllist = this.getIngredients();
        if (nonnulllist.isEmpty()) {
            return true;
        }
        return nonnulllist.stream().filter(ingredient -> !ingredient.isEmpty()).anyMatch(CommonHooks::hasNoElements);
    }
}

