/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.common.register.IEIngredients;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class IngredientFluidStack
extends Ingredient {
    public static final Codec<IngredientFluidStack> CODEC = FluidTagInput.CODEC.xmap(IngredientFluidStack::new, IngredientFluidStack::getFluidTagInput);
    private final FluidTagInput fluidTagInput;
    ItemStack[] cachedStacks;

    public IngredientFluidStack(FluidTagInput fluidTagInput) {
        super(Stream.empty(), () -> IEIngredients.FLUID_STACK.value());
        this.fluidTagInput = fluidTagInput;
    }

    public IngredientFluidStack(TagKey<Fluid> tag, int amount) {
        this(new FluidTagInput(tag, amount, null));
    }

    public FluidTagInput getFluidTagInput() {
        return this.fluidTagInput;
    }

    @Nonnull
    public ItemStack[] getItems() {
        if (this.cachedStacks == null) {
            this.cachedStacks = (ItemStack[])this.fluidTagInput.getMatchingFluidStacks().stream().map(FluidUtil::getFilledBucket).filter(s -> !s.isEmpty()).toArray(ItemStack[]::new);
        }
        return this.cachedStacks;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Optional handler = FluidUtil.getFluidHandler((ItemStack)stack);
        return handler.isPresent() && this.fluidTagInput.extractFrom((IFluidHandler)handler.get(), IFluidHandler.FluidAction.SIMULATE);
    }

    public boolean isSimple() {
        return false;
    }

    public ItemStack getExtractedStack(ItemStack input) {
        IFluidHandlerItem handler = (IFluidHandlerItem)ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)1).getCapability(Capabilities.FluidHandler.ITEM);
        if (handler != null) {
            this.fluidTagInput.extractFrom((IFluidHandler)handler, IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }
        return input.getCraftingRemainingItem();
    }
}

