/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractFluidAwareRecipe;
import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractShapedRecipe;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.mixin.accessors.ShapedRecipeAccess;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class TurnAndCopyRecipe
extends AbstractShapedRecipe<MatchLocation> {
    protected boolean allowQuarter;
    protected boolean allowEighth;
    @Nonnull
    protected final List<Integer> nbtCopyTargetSlot;
    protected Pattern nbtCopyPredicate = null;

    public TurnAndCopyRecipe(ShapedRecipe vanilla) {
        this(vanilla, List.of());
    }

    public TurnAndCopyRecipe(ShapedRecipe vanilla, List<Integer> copySlots) {
        super(vanilla.getGroup(), vanilla.getWidth(), vanilla.getHeight(), (NonNullList<Ingredient>)vanilla.getIngredients(), vanilla.getResultItem(null), vanilla.category(), ((ShapedRecipeAccess)vanilla).getPattern().data());
        this.nbtCopyTargetSlot = copySlots;
    }

    public TurnAndCopyRecipe allowQuarterTurn() {
        this.allowQuarter = true;
        return this;
    }

    public TurnAndCopyRecipe allowEighthTurn() {
        if (this.getWidth() == 3 && this.getHeight() == 3) {
            this.allowEighth = true;
        }
        return this;
    }

    public void setNBTCopyPredicate(String pattern) {
        this.nbtCopyPredicate = Pattern.compile(pattern);
    }

    @Override
    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer matrix, RegistryAccess access) {
        ItemStack out = super.assemble(matrix, access);
        CompoundTag tag = new CompoundTag();
        for (int targetSlot : this.nbtCopyTargetSlot) {
            ItemStack s = matrix.getItem(targetSlot);
            if (s.isEmpty() || !s.hasTag()) continue;
            tag = ItemNBTHelper.combineTags(tag, s.getOrCreateTag(), this.nbtCopyPredicate);
        }
        if (!tag.isEmpty()) {
            out.setTag(tag);
        }
        return out;
    }

    @Override
    @Nullable
    protected MatchLocation findMatch(CraftingContainer inv) {
        for (int xOffset = 0; xOffset <= inv.getWidth() - this.getWidth(); ++xOffset) {
            for (int yOffset = 0; yOffset <= inv.getHeight() - this.getHeight(); ++yOffset) {
                for (boolean mirror : BOOLEANS) {
                    for (Rotation rot : Rotation.values()) {
                        MatchLocation loc;
                        if (!rot.allowed.test(this) || !this.checkMatchDo(inv, loc = new MatchLocation(xOffset, yOffset, mirror, rot, this.getWidth(), this.getHeight()))) continue;
                        return loc;
                    }
                }
            }
        }
        return null;
    }

    private boolean checkMatchDo(CraftingContainer inv, MatchLocation loc) {
        for (int x = 0; x < inv.getWidth(); ++x) {
            for (int y = 0; y < inv.getHeight(); ++y) {
                ItemStack slot;
                Ingredient target = Ingredient.EMPTY;
                int index = loc.getListIndex(x, y);
                if (index >= 0) {
                    target = (Ingredient)this.getIngredients().get(index);
                }
                if (target.test(slot = inv.getItem(x + y * inv.getWidth()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.TURN_AND_COPY_SERIALIZER.get();
    }

    public boolean isQuarterTurn() {
        return this.allowQuarter;
    }

    public boolean isEightTurn() {
        return this.allowEighth;
    }

    public List<Integer> getCopyTargets() {
        return this.nbtCopyTargetSlot;
    }

    public boolean hasCopyPredicate() {
        return this.nbtCopyPredicate != null;
    }

    public String getBufferPredicate() {
        if (this.nbtCopyPredicate != null) {
            return this.nbtCopyPredicate.pattern();
        }
        return null;
    }

    private static enum Rotation {
        NONE(s -> true),
        QUARTER(TurnAndCopyRecipe::isQuarterTurn),
        EIGHTH(TurnAndCopyRecipe::isEightTurn);

        private static final int[] eighthTurnMap;
        private final Predicate<TurnAndCopyRecipe> allowed;

        private Rotation(Predicate<TurnAndCopyRecipe> allowed) {
            this.allowed = allowed;
        }

        public boolean isValid(int x, int y, int width, int height) {
            if (this == QUARTER) {
                int temp = x;
                x = y;
                y = temp;
            }
            return x >= 0 && x < width && y >= 0 && y < height;
        }

        public int getIndex(int x, int y, int width, int height) {
            switch (this) {
                case NONE: {
                    return y * width + x;
                }
                case QUARTER: {
                    return x * width + (height - 1 - y);
                }
                case EIGHTH: {
                    int i = y * width + x;
                    return i + eighthTurnMap[i];
                }
            }
            throw new UnsupportedOperationException();
        }

        static {
            eighthTurnMap = new int[]{3, -1, -1, 3, 0, -3, 1, 1, -3};
        }
    }

    public static class MatchLocation
    implements AbstractFluidAwareRecipe.IMatchLocation {
        private final int offsetX;
        private final int offsetY;
        private final boolean mirrored;
        private final Rotation rotation;
        private final int recipeWidth;
        private final int recipeHeight;

        public MatchLocation(int offsetX, int offsetY, boolean mirrored, Rotation rotation, int recipeWidth, int recipeHeight) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.mirrored = mirrored;
            this.rotation = rotation;
            this.recipeWidth = recipeWidth;
            this.recipeHeight = recipeHeight;
        }

        @Override
        public int getListIndex(int x, int y) {
            x -= this.offsetX;
            y -= this.offsetY;
            if (this.mirrored) {
                x = this.recipeWidth - 1 - x;
            }
            if (this.rotation.isValid(x, y, this.recipeWidth, this.recipeHeight)) {
                return this.rotation.getIndex(x, y, this.recipeWidth, this.recipeHeight);
            }
            return -1;
        }
    }
}

