/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public class AlloyRecipeSerializer
extends IERecipeSerializer<AlloyRecipe> {
    private static final Codec<AlloyRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagOutput.CODEC.fieldOf("result").forGetter(r -> r.output), (App)IngredientWithSize.CODEC.fieldOf("input0").forGetter(r -> r.input0), (App)IngredientWithSize.CODEC.fieldOf("input1").forGetter(r -> r.input1), (App)ExtraCodecs.strictOptionalField((Codec)Codec.INT, (String)"time", (Object)200).forGetter(r -> r.time)).apply((Applicative)inst, AlloyRecipe::new));

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.ALLOY_SMELTER.iconStack();
    }

    public Codec<AlloyRecipe> codec() {
        return CODEC;
    }

    @Nullable
    public AlloyRecipe fromNetwork(FriendlyByteBuf buffer) {
        TagOutput output = AlloyRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input0 = IngredientWithSize.read(buffer);
        IngredientWithSize input1 = IngredientWithSize.read(buffer);
        int time = buffer.readInt();
        return new AlloyRecipe(output, input0, input1, time);
    }

    public void toNetwork(FriendlyByteBuf buffer, AlloyRecipe recipe) {
        AlloyRecipeSerializer.writeLazyStack(buffer, recipe.output);
        recipe.input0.write(buffer);
        recipe.input1.write(buffer);
        buffer.writeInt(recipe.time);
    }
}

