/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public class ArcFurnaceRecipeSerializer
extends IERecipeSerializer<ArcFurnaceRecipe> {
    public static final Codec<ArcFurnaceRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagOutputList.CODEC.fieldOf("results").forGetter(r -> r.output), (App)ExtraCodecs.strictOptionalField(TagOutput.CODEC, (String)"slag", (Object)TagOutput.EMPTY).forGetter(r -> r.slag), (App)ExtraCodecs.strictOptionalField((Codec)CHANCE_LIST, (String)"secondaries", List.of()).forGetter(r -> r.secondaryOutputs), (App)Codec.INT.fieldOf("time").forGetter(MultiblockRecipe::getBaseTime), (App)Codec.INT.fieldOf("energy").forGetter(MultiblockRecipe::getBaseEnergy), (App)IngredientWithSize.CODEC.fieldOf("input").forGetter(r -> r.input), (App)IngredientWithSize.CODEC.listOf().fieldOf("additives").forGetter(r -> r.additives)).apply((Applicative)inst, ArcFurnaceRecipe::new));

    public Codec<ArcFurnaceRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.ARC_FURNACE.iconStack();
    }

    @Nullable
    public ArcFurnaceRecipe fromNetwork(FriendlyByteBuf buffer) {
        TagOutputList outputs = new TagOutputList(PacketUtils.readList(buffer, x$0 -> IERecipeSerializer.readLazyStack(x$0)));
        List<StackWithChance> secondaries = PacketUtils.readList(buffer, StackWithChance::read);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        List<IngredientWithSize> additives = PacketUtils.readList(buffer, IngredientWithSize::read);
        TagOutput slag = ArcFurnaceRecipeSerializer.readLazyStack(buffer);
        int time = buffer.readInt();
        int energy = buffer.readInt();
        if (!buffer.readBoolean()) {
            return new ArcFurnaceRecipe(outputs, slag, secondaries, time, energy, input, additives);
        }
        int numOutputs = buffer.readVarInt();
        ArrayList<Pair<TagOutput, Double>> recyclingOutputs = new ArrayList<Pair<TagOutput, Double>>(numOutputs);
        for (int i = 0; i < numOutputs; ++i) {
            recyclingOutputs.add(Pair.of((Object)ArcFurnaceRecipeSerializer.readLazyStack(buffer), (Object)buffer.readDouble()));
        }
        return new ArcRecyclingRecipe(() -> Minecraft.getInstance().getConnection().registryAccess(), recyclingOutputs, input, time, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, ArcFurnaceRecipe recipe) {
        PacketUtils.writeListReverse(buffer, recipe.output.get(), FriendlyByteBuf::writeItem);
        PacketUtils.writeList(buffer, recipe.secondaryOutputs, StackWithChance::write);
        recipe.input.write(buffer);
        PacketUtils.writeList(buffer, recipe.additives, IngredientWithSize::write);
        buffer.writeItem(recipe.slag.get());
        buffer.writeInt(recipe.getTotalProcessTime());
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeBoolean(recipe instanceof ArcRecyclingRecipe);
        if (recipe instanceof ArcRecyclingRecipe) {
            ArcRecyclingRecipe recyclingRecipe = (ArcRecyclingRecipe)recipe;
            List<Pair<TagOutput, Double>> outputs = recyclingRecipe.getOutputs();
            buffer.writeVarInt(outputs.size());
            for (Pair<TagOutput, Double> e : outputs) {
                buffer.writeItem(((TagOutput)e.getFirst()).get());
                buffer.writeDouble(((Double)e.getSecond()).doubleValue());
            }
        }
    }
}

