/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class BlastFurnaceFuelSerializer
extends IERecipeSerializer<BlastFurnaceFuel> {
    public static final Codec<BlastFurnaceFuel> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Ingredient.CODEC.fieldOf("input").forGetter(f -> f.input), (App)Codec.INT.fieldOf("time").forGetter(f -> f.burnTime)).apply((Applicative)inst, BlastFurnaceFuel::new));

    public Codec<BlastFurnaceFuel> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEItems.Ingredients.COAL_COKE);
    }

    @Nullable
    public BlastFurnaceFuel fromNetwork(FriendlyByteBuf buffer) {
        Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        int time = buffer.readInt();
        return new BlastFurnaceFuel(input, time);
    }

    public void toNetwork(FriendlyByteBuf buffer, BlastFurnaceFuel recipe) {
        recipe.input.toNetwork(buffer);
        buffer.writeInt(recipe.burnTime);
    }
}

