/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public class BlastFurnaceRecipeSerializer
extends IERecipeSerializer<BlastFurnaceRecipe> {
    public static final Codec<BlastFurnaceRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagOutput.CODEC.fieldOf("result").forGetter(r -> r.output), (App)IngredientWithSize.CODEC.fieldOf("input").forGetter(r -> r.input), (App)ExtraCodecs.strictOptionalField((Codec)Codec.INT, (String)"time", (Object)200).forGetter(r -> r.time), (App)BlastFurnaceRecipeSerializer.optionalItemOutput("slag").forGetter(r -> r.slag)).apply((Applicative)inst, BlastFurnaceRecipe::new));

    public Codec<BlastFurnaceRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.BLAST_FURNACE.iconStack();
    }

    @Nullable
    public BlastFurnaceRecipe fromNetwork(FriendlyByteBuf buffer) {
        TagOutput output = BlastFurnaceRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        int time = buffer.readInt();
        TagOutput slag = TagOutput.EMPTY;
        if (buffer.readBoolean()) {
            slag = BlastFurnaceRecipeSerializer.readLazyStack(buffer);
        }
        return new BlastFurnaceRecipe(output, input, time, slag);
    }

    public void toNetwork(FriendlyByteBuf buffer, BlastFurnaceRecipe recipe) {
        BlastFurnaceRecipeSerializer.writeLazyStack(buffer, recipe.output);
        recipe.input.write(buffer);
        buffer.writeInt(recipe.time);
        buffer.writeBoolean(!recipe.slag.get().isEmpty());
        if (!recipe.slag.get().isEmpty()) {
            buffer.writeItem(recipe.slag.get());
        }
    }
}

