/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class BlueprintCraftingRecipeSerializer
extends IERecipeSerializer<BlueprintCraftingRecipe> {
    public static final Codec<BlueprintCraftingRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("category").forGetter(r -> r.blueprintCategory), (App)TagOutput.CODEC.fieldOf("result").forGetter(r -> r.output), (App)IngredientWithSize.CODEC.listOf().fieldOf("inputs").forGetter(r -> r.inputs)).apply((Applicative)inst, BlueprintCraftingRecipe::new));

    public Codec<BlueprintCraftingRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.WoodenDevices.WORKBENCH);
    }

    @Nullable
    public BlueprintCraftingRecipe fromNetwork(FriendlyByteBuf buffer) {
        String category = buffer.readUtf();
        TagOutput output = BlueprintCraftingRecipeSerializer.readLazyStack(buffer);
        int inputCount = buffer.readInt();
        ArrayList<IngredientWithSize> ingredients = new ArrayList<IngredientWithSize>();
        for (int i = 0; i < inputCount; ++i) {
            ingredients.add(IngredientWithSize.read(buffer));
        }
        return new BlueprintCraftingRecipe(category, output, ingredients);
    }

    public void toNetwork(FriendlyByteBuf buffer, BlueprintCraftingRecipe recipe) {
        buffer.writeUtf(recipe.blueprintCategory);
        BlueprintCraftingRecipeSerializer.writeLazyStack(buffer, recipe.output);
        buffer.writeInt(recipe.inputs.size());
        for (IngredientWithSize ingredient : recipe.inputs) {
            ingredient.write(buffer);
        }
    }
}

