/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class BottlingMachineRecipeSerializer
extends IERecipeSerializer<BottlingMachineRecipe> {
    public static final Codec<BottlingMachineRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagOutputList.CODEC.fieldOf("results").forGetter(r -> r.output), (App)BottlingMachineRecipeSerializer.listOrSingle(IngredientWithSize.CODEC, "input", "inputs").forGetter(r -> r.inputs), (App)FluidTagInput.CODEC.fieldOf("fluid").forGetter(r -> r.fluidInput)).apply((Applicative)inst, BottlingMachineRecipe::new));

    public Codec<BottlingMachineRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.BOTTLING_MACHINE.iconStack();
    }

    @Nullable
    public BottlingMachineRecipe fromNetwork(FriendlyByteBuf buffer) {
        List<TagOutput> outputs = PacketUtils.readList(buffer, x$0 -> IERecipeSerializer.readLazyStack(x$0));
        List<IngredientWithSize> ingredients = PacketUtils.readList(buffer, IngredientWithSize::read);
        FluidTagInput fluidInput = FluidTagInput.read(buffer);
        return new BottlingMachineRecipe(new TagOutputList(outputs), ingredients, fluidInput);
    }

    public void toNetwork(FriendlyByteBuf buffer, BottlingMachineRecipe recipe) {
        PacketUtils.writeListReverse(buffer, recipe.output.get(), FriendlyByteBuf::writeItem);
        PacketUtils.writeList(buffer, recipe.inputs, IngredientWithSize::write);
        recipe.fluidInput.write(buffer);
    }
}

