/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ClocheFertilizerSerializer
extends IERecipeSerializer<ClocheFertilizer> {
    public static final Codec<ClocheFertilizer> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Codec.FLOAT.fieldOf("growthModifier").forGetter(r -> Float.valueOf(r.growthModifier))).apply((Applicative)inst, ClocheFertilizer::new));

    public Codec<ClocheFertilizer> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Items.BONE_MEAL);
    }

    @Nullable
    public ClocheFertilizer fromNetwork(FriendlyByteBuf buffer) {
        Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        float growthModifier = buffer.readFloat();
        return new ClocheFertilizer(input, growthModifier);
    }

    public void toNetwork(FriendlyByteBuf buffer, ClocheFertilizer recipe) {
        recipe.input.toNetwork(buffer);
        buffer.writeFloat(recipe.growthModifier);
    }
}

