/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ClocheRecipeSerializer
extends IERecipeSerializer<ClocheRecipe> {
    public static final Codec<ClocheRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagOutputList.CODEC.fieldOf("results").forGetter(r -> r.outputs), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.seed), (App)Ingredient.CODEC.fieldOf("soil").forGetter(r -> r.soil), (App)Codec.INT.fieldOf("time").forGetter(r -> r.time), (App)ClocheRenderFunction.CODEC.fieldOf("render").forGetter(r -> r.renderFunction)).apply((Applicative)inst, ClocheRecipe::new));

    public Codec<ClocheRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.MetalDevices.CLOCHE);
    }

    @NotNull
    public ClocheRecipe fromNetwork(FriendlyByteBuf buffer) {
        int outputCount = buffer.readInt();
        ArrayList<TagOutput> outputs = new ArrayList<TagOutput>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            outputs.add(ClocheRecipeSerializer.readLazyStack(buffer));
        }
        Ingredient seed = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        Ingredient soil = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        int time = buffer.readInt();
        ClocheRenderFunction renderFunction = ClocheRenderFunction.read(buffer);
        return new ClocheRecipe(new TagOutputList(outputs), seed, soil, time, renderFunction);
    }

    public void toNetwork(FriendlyByteBuf buffer, ClocheRecipe recipe) {
        buffer.writeInt(recipe.outputs.getLazyList().size());
        for (TagOutput stack : recipe.outputs.getLazyList()) {
            buffer.writeItem(stack.get());
        }
        recipe.seed.toNetwork(buffer);
        recipe.soil.toNetwork(buffer);
        buffer.writeInt(recipe.time);
        ClocheRenderFunction.write(buffer, recipe.renderFunction);
    }
}

