/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public class CokeOvenRecipeSerializer
extends IERecipeSerializer<CokeOvenRecipe> {
    public static final Codec<CokeOvenRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagOutput.CODEC.fieldOf("result").forGetter(r -> r.output), (App)IngredientWithSize.CODEC.fieldOf("input").forGetter(r -> r.input), (App)ExtraCodecs.strictOptionalField((Codec)Codec.INT, (String)"time", (Object)200).forGetter(r -> r.time), (App)Codec.INT.fieldOf("creosote").forGetter(r -> r.creosoteOutput)).apply((Applicative)inst, CokeOvenRecipe::new));

    public Codec<CokeOvenRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.COKE_OVEN.iconStack();
    }

    @Nullable
    public CokeOvenRecipe fromNetwork(FriendlyByteBuf buffer) {
        TagOutput output = CokeOvenRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        int time = buffer.readInt();
        int oil = buffer.readInt();
        return new CokeOvenRecipe(output, input, time, oil);
    }

    public void toNetwork(FriendlyByteBuf buffer, CokeOvenRecipe recipe) {
        CokeOvenRecipeSerializer.writeLazyStack(buffer, recipe.output);
        recipe.input.write(buffer);
        buffer.writeInt(recipe.time);
        buffer.writeInt(recipe.creosoteOutput);
    }
}

