/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CrusherRecipeSerializer
extends IERecipeSerializer<CrusherRecipe> {
    public static final Codec<CrusherRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagOutput.CODEC.fieldOf("result").forGetter(r -> r.output), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Codec.INT.fieldOf("energy").forGetter(MultiblockRecipe::getBaseEnergy), (App)ExtraCodecs.strictOptionalField((Codec)CHANCE_LIST, (String)"secondaries", List.of()).forGetter(r -> r.secondaryOutputs)).apply((Applicative)inst, CrusherRecipe::new));

    public Codec<CrusherRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.CRUSHER.iconStack();
    }

    @Nullable
    public CrusherRecipe fromNetwork(FriendlyByteBuf buffer) {
        ItemStack output = buffer.readItem();
        Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        List<StackWithChance> secondaries = PacketUtils.readList(buffer, StackWithChance::read);
        return new CrusherRecipe(new TagOutput(output), input, energy, secondaries);
    }

    public void toNetwork(FriendlyByteBuf buffer, CrusherRecipe recipe) {
        buffer.writeItem(recipe.output.get());
        recipe.input.toNetwork(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        PacketUtils.writeList(buffer, recipe.secondaryOutputs, StackWithChance::write);
    }
}

