/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.common.crafting.DamageToolRecipe;
import blusunrize.immersiveengineering.common.util.IECodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class DamageToolRecipeSerializer
implements RecipeSerializer<DamageToolRecipe> {
    public static final Codec<DamageToolRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("group").forGetter(ShapelessRecipe::getGroup), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(r -> r.getResultItem(null)), (App)Ingredient.CODEC.fieldOf("tool").forGetter(DamageToolRecipe::getTool), (App)IECodecs.NONNULL_INGREDIENTS.fieldOf("ingredients").forGetter(ShapelessRecipe::getIngredients)).apply((Applicative)inst, DamageToolRecipe::new));

    public Codec<DamageToolRecipe> codec() {
        return CODEC;
    }

    @Nonnull
    public DamageToolRecipe fromNetwork(@Nonnull FriendlyByteBuf buffer) {
        int stdCount = buffer.readInt();
        NonNullList stdIngr = NonNullList.create();
        for (int i = 0; i < stdCount; ++i) {
            stdIngr.add((Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
        }
        Ingredient tool = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        String group = buffer.readUtf(512);
        ItemStack output = buffer.readItem();
        return new DamageToolRecipe(group, output, tool, (NonNullList<Ingredient>)stdIngr);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull DamageToolRecipe recipe) {
        int standardCount = recipe.getIngredients().size() - 1;
        buffer.writeInt(standardCount);
        for (int i = 0; i < standardCount; ++i) {
            ((Ingredient)recipe.getIngredients().get(i)).toNetwork(buffer);
        }
        recipe.getTool().toNetwork(buffer);
        buffer.writeUtf(recipe.getGroup());
        buffer.writeItem(recipe.getResultItem(null));
    }
}

