/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class FermenterRecipeSerializer
extends IERecipeSerializer<FermenterRecipe> {
    public static final Codec<FermenterRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)FermenterRecipeSerializer.optionalFluidOutput("fluid").forGetter(r -> r.fluidOutput), (App)FermenterRecipeSerializer.optionalItemOutput("result").forGetter(r -> r.itemOutput), (App)IngredientWithSize.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Codec.INT.fieldOf("energy").forGetter(MultiblockRecipe::getBaseEnergy)).apply((Applicative)inst, FermenterRecipe::new));

    public Codec<FermenterRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.FERMENTER.iconStack();
    }

    @Nullable
    public FermenterRecipe fromNetwork(FriendlyByteBuf buffer) {
        FluidStack fluidOutput = buffer.readFluidStack();
        TagOutput itemOutput = FermenterRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        int energy = buffer.readInt();
        return new FermenterRecipe(fluidOutput, itemOutput, input, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, FermenterRecipe recipe) {
        buffer.writeFluidStack(recipe.fluidOutput);
        buffer.writeItem(recipe.itemOutput.get());
        recipe.input.write(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

