/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class GeneratedListSerializer
extends IERecipeSerializer<GeneratedListRecipe<?, ?>> {
    public static final Codec<GeneratedListRecipe<?, ?>> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("generatorID").forGetter(GeneratedListRecipe::getGeneratorID)).apply((Applicative)inst, GeneratedListRecipe::from));

    public Codec<GeneratedListRecipe<?, ?>> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER));
    }

    @Nullable
    public GeneratedListRecipe<?, ?> fromNetwork(@Nonnull FriendlyByteBuf buffer) {
        int length = buffer.readVarInt();
        ArrayList<IESerializableRecipe> subRecipes = new ArrayList<IESerializableRecipe>(length);
        ResourceLocation recipeCategory = buffer.readResourceLocation();
        RecipeSerializer deserializer = Objects.requireNonNull((RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.get(recipeCategory));
        for (int i = 0; i < length; ++i) {
            Recipe subRecipe = deserializer.fromNetwork(buffer);
            subRecipes.add((IESerializableRecipe)subRecipe);
        }
        ResourceLocation serializerID = buffer.readResourceLocation();
        return GeneratedListRecipe.resolved(serializerID, subRecipes);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull GeneratedListRecipe<?, ?> recipe) {
        List<IESerializableRecipe> recipes = recipe.getSubRecipes();
        buffer.writeVarInt(recipes.size());
        buffer.writeResourceLocation(recipe.getSubSerializer());
        for (IESerializableRecipe r : recipes) {
            ((IERecipeSerializer)r.getSerializer()).toNetwork(buffer, r);
        }
        buffer.writeResourceLocation(recipe.getGeneratorID());
    }
}

