/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.energy.GeneratorFuel;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;

public class GeneratorFuelSerializer
extends IERecipeSerializer<GeneratorFuel> {
    public static final Codec<GeneratorFuel> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.mapEither((MapCodec)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("fluidTag"), (MapCodec)BuiltInRegistries.FLUID.byNameCodec().listOf().fieldOf("fluidList")).forGetter(f -> f.getFluidsRaw().map(Either::left, Either::right)), (App)Codec.INT.fieldOf("burnTime").forGetter(GeneratorFuel::getBurnTime)).apply((Applicative)inst, GeneratorFuel::new));

    public Codec<GeneratorFuel> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.DIESEL_GENERATOR.iconStack();
    }

    @Nullable
    public GeneratorFuel fromNetwork(@Nonnull FriendlyByteBuf buffer) {
        List<Fluid> fluids = PacketUtils.readList(buffer, buf -> (Fluid)PacketUtils.readRegistryElement(buf, BuiltInRegistries.FLUID));
        int burnTime = buffer.readInt();
        return new GeneratorFuel(fluids, burnTime);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull GeneratorFuel recipe) {
        PacketUtils.writeList(buffer, recipe.getFluids(), (f, buf) -> PacketUtils.writeRegistryElement(buf, BuiltInRegistries.FLUID, f));
        buffer.writeInt(recipe.getBurnTime());
    }
}

