/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.crafting.LazyShapelessRecipe;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class HammerCrushingRecipeSerializer
extends IERecipeSerializer<LazyShapelessRecipe> {
    private final Codec<LazyShapelessRecipe> codec = RecordCodecBuilder.create(inst -> inst.group((App)TagOutput.CODEC.fieldOf("result").forGetter(LazyShapelessRecipe::getResult), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> (Ingredient)r.getIngredients().get(0))).apply((Applicative)inst, (result, input) -> new LazyShapelessRecipe("", (TagOutput)result, (NonNullList<Ingredient>)NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{input, Ingredient.of((ItemLike[])new ItemLike[]{IEItems.Tools.HAMMER})}), this)));

    public Codec<LazyShapelessRecipe> codec() {
        return this.codec;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Blocks.CRAFTING_TABLE);
    }

    @Nonnull
    public LazyShapelessRecipe fromNetwork(@Nonnull FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        NonNullList ingredients = NonNullList.withSize((int)count, (Object)Ingredient.EMPTY);
        for (int i = 0; i < count; ++i) {
            ingredients.set(i, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
        }
        TagOutput output = HammerCrushingRecipeSerializer.readLazyStack(buffer);
        return new LazyShapelessRecipe("", output, (NonNullList<Ingredient>)ingredients, this);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull LazyShapelessRecipe recipe) {
        NonNullList ingredients = recipe.getIngredients();
        buffer.writeInt(ingredients.size());
        for (Ingredient ingredient : ingredients) {
            ingredient.toNetwork(buffer);
        }
        buffer.writeItem(recipe.getResultItem(null));
    }
}

