/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MetalPressRecipeSerializer
extends IERecipeSerializer<MetalPressRecipe> {
    public static final Codec<MetalPressRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagOutput.CODEC.fieldOf("result").forGetter(r -> r.output), (App)IngredientWithSize.CODEC.fieldOf("input").forGetter(r -> r.input), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("mold").forGetter(r -> r.mold), (App)Codec.INT.fieldOf("energy").forGetter(MultiblockRecipe::getBaseEnergy)).apply((Applicative)inst, MetalPressRecipe::new));

    public Codec<MetalPressRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.METAL_PRESS.iconStack();
    }

    @Nullable
    public MetalPressRecipe fromNetwork(FriendlyByteBuf buffer) {
        TagOutput output = MetalPressRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        Item mold = (Item)PacketUtils.readRegistryElement(buffer, BuiltInRegistries.ITEM);
        int energy = buffer.readInt();
        return new MetalPressRecipe(output, input, mold, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, MetalPressRecipe recipe) {
        MetalPressRecipeSerializer.writeLazyStack(buffer, recipe.output);
        recipe.input.write(buffer);
        PacketUtils.writeRegistryElement(buffer, BuiltInRegistries.ITEM, recipe.mold);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

