/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class MineralMixSerializer
extends IERecipeSerializer<MineralMix> {
    public static final Codec<MineralMix.BiomeTagPredicate> BIOME_TAG_PREDICATE_CODEC = NeoForgeExtraCodecs.setOf((Codec)TagKey.codec((ResourceKey)Registries.BIOME)).xmap(MineralMix.BiomeTagPredicate::new, MineralMix.BiomeTagPredicate::tags);
    private static final Codec<MineralMix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CHANCE_LIST.fieldOf("ores").forGetter(r -> r.outputs), (App)CHANCE_LIST.fieldOf("spoils").forGetter(r -> r.spoils), (App)Codec.INT.fieldOf("weight").forGetter(r -> r.weight), (App)ExtraCodecs.strictOptionalField((Codec)Codec.FLOAT, (String)"fail_chance", (Object)Float.valueOf(0.0f)).forGetter(r -> Float.valueOf(r.failChance)), (App)NeoForgeExtraCodecs.setOf(BIOME_TAG_PREDICATE_CODEC).fieldOf("biome_predicates").forGetter(r -> r.biomeTagPredicates), (App)ExtraCodecs.strictOptionalField((Codec)BuiltInRegistries.BLOCK.byNameCodec(), (String)"sample_background", (Object)Blocks.STONE).forGetter(r -> r.background)).apply((Applicative)inst, (ores, spoils, weight, failChance, biomes, background) -> {
        double finalTotalChance = ores.stream().mapToDouble(StackWithChance::chance).sum();
        ores = ores.stream().map(stack -> stack.recalculate(finalTotalChance)).toList();
        double finalSpoilChance = spoils.stream().mapToDouble(StackWithChance::chance).sum();
        spoils = spoils.stream().map(stack -> stack.recalculate(finalSpoilChance)).toList();
        return new MineralMix((List<StackWithChance>)ores, (List<StackWithChance>)spoils, (int)weight, failChance.floatValue(), (Collection<MineralMix.BiomeTagPredicate>)biomes, (Block)background);
    }));

    public Codec<MineralMix> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.CRUSHER.iconStack();
    }

    @Nullable
    public MineralMix fromNetwork(FriendlyByteBuf buffer) {
        List<StackWithChance> outputs = PacketUtils.readList(buffer, StackWithChance::read);
        List<StackWithChance> spoils = PacketUtils.readList(buffer, StackWithChance::read);
        int weight = buffer.readInt();
        float failChance = buffer.readFloat();
        int totalPredicates = buffer.readInt();
        ArrayList<MineralMix.BiomeTagPredicate> biomes = new ArrayList<MineralMix.BiomeTagPredicate>(totalPredicates);
        for (int i = 0; i < totalPredicates; ++i) {
            int count = buffer.readInt();
            HashSet<TagKey<Biome>> tags = new HashSet<TagKey<Biome>>(count);
            for (int j = 0; j < count; ++j) {
                tags.add((TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)buffer.readResourceLocation()));
            }
            biomes.add(new MineralMix.BiomeTagPredicate(tags));
        }
        Block bg = (Block)PacketUtils.readRegistryElement(buffer, BuiltInRegistries.BLOCK);
        return new MineralMix(outputs, spoils, weight, failChance, biomes, bg);
    }

    public void toNetwork(FriendlyByteBuf buffer, MineralMix recipe) {
        PacketUtils.writeList(buffer, recipe.outputs, StackWithChance::write);
        PacketUtils.writeList(buffer, recipe.spoils, StackWithChance::write);
        buffer.writeInt(recipe.weight);
        buffer.writeFloat(recipe.failChance);
        buffer.writeInt(recipe.biomeTagPredicates.size());
        for (MineralMix.BiomeTagPredicate biomes : recipe.biomeTagPredicates) {
            buffer.writeInt(biomes.tags().size());
            for (TagKey<Biome> tag : biomes.tags()) {
                buffer.writeResourceLocation(tag.location());
            }
        }
        PacketUtils.writeRegistryElement(buffer, BuiltInRegistries.BLOCK, recipe.background);
    }
}

