/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class MixerRecipeSerializer
extends IERecipeSerializer<MixerRecipe> {
    public static final Codec<MixerRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)FluidStack.CODEC.fieldOf("result").forGetter(r -> r.fluidOutput), (App)FluidTagInput.CODEC.fieldOf("fluid").forGetter(r -> r.fluidInput), (App)IngredientWithSize.CODEC.listOf().fieldOf("inputs").forGetter(r -> r.itemInputs), (App)Codec.INT.fieldOf("energy").forGetter(MultiblockRecipe::getBaseEnergy)).apply((Applicative)inst, MixerRecipe::new));

    public Codec<MixerRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.MIXER.iconStack();
    }

    @Nullable
    public MixerRecipe fromNetwork(FriendlyByteBuf buffer) {
        FluidStack fluidOutput = buffer.readFluidStack();
        FluidTagInput fluidInput = FluidTagInput.read(buffer);
        List<IngredientWithSize> itemInputs = PacketUtils.readList(buffer, IngredientWithSize::read);
        int energy = buffer.readInt();
        return new MixerRecipe(fluidOutput, fluidInput, itemInputs, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, MixerRecipe recipe) {
        buffer.writeFluidStack(recipe.fluidOutput);
        recipe.fluidInput.write(buffer);
        PacketUtils.writeList(buffer, recipe.itemInputs, IngredientWithSize::write);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

