/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;

public class RefineryRecipeSerializer
extends IERecipeSerializer<RefineryRecipe> {
    public static final Codec<RefineryRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)FluidStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)FluidTagInput.CODEC.fieldOf("input0").forGetter(r -> r.input0), (App)ExtraCodecs.strictOptionalField(FluidTagInput.CODEC, (String)"input1").forGetter(r -> Optional.ofNullable(r.input1)), (App)ExtraCodecs.strictOptionalField((Codec)Ingredient.CODEC, (String)"catalyst", (Object)Ingredient.EMPTY).forGetter(r -> r.catalyst), (App)Codec.INT.fieldOf("energy").forGetter(MultiblockRecipe::getBaseEnergy)).apply((Applicative)inst, RefineryRecipe::new));

    public Codec<RefineryRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.REFINERY.iconStack();
    }

    @Nullable
    public RefineryRecipe fromNetwork(FriendlyByteBuf buffer) {
        FluidStack output = buffer.readFluidStack();
        FluidTagInput input0 = FluidTagInput.read(buffer);
        FluidTagInput input1 = buffer.readBoolean() ? FluidTagInput.read(buffer) : null;
        Ingredient catalyst = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        return new RefineryRecipe(output, input0, input1, catalyst, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, RefineryRecipe recipe) {
        buffer.writeFluidStack(recipe.output);
        recipe.input0.write(buffer);
        if (recipe.input1 != null) {
            buffer.writeBoolean(true);
            recipe.input1.write(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        recipe.catalyst.toNetwork(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

