/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class SawmillRecipeSerializer
extends IERecipeSerializer<SawmillRecipe> {
    public static final Codec<SawmillRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagOutput.CODEC.fieldOf("result").forGetter(r -> r.output), (App)SawmillRecipeSerializer.optionalItemOutput("stripped").forGetter(r -> r.stripped), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Codec.INT.fieldOf("energy").forGetter(MultiblockRecipe::getBaseEnergy), (App)ExtraCodecs.strictOptionalField(TagOutputList.CODEC, (String)"strippingSecondaries", (Object)TagOutputList.EMPTY).forGetter(r -> r.secondaryStripping), (App)ExtraCodecs.strictOptionalField(TagOutputList.CODEC, (String)"secondaryOutputs", (Object)TagOutputList.EMPTY).forGetter(r -> r.secondaryOutputs)).apply((Applicative)inst, SawmillRecipe::new));

    public Codec<SawmillRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.SAWMILL.iconStack();
    }

    @Nullable
    public SawmillRecipe fromNetwork(FriendlyByteBuf buffer) {
        TagOutput output = SawmillRecipeSerializer.readLazyStack(buffer);
        TagOutput stripped = SawmillRecipeSerializer.readLazyStack(buffer);
        Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        int secondaryCount = buffer.readInt();
        ArrayList<TagOutput> strippingOutputs = new ArrayList<TagOutput>();
        for (int i = 0; i < secondaryCount; ++i) {
            strippingOutputs.add(SawmillRecipeSerializer.readLazyStack(buffer));
        }
        ArrayList<TagOutput> secondaryOutputs = new ArrayList<TagOutput>();
        secondaryCount = buffer.readInt();
        for (int i = 0; i < secondaryCount; ++i) {
            secondaryOutputs.add(SawmillRecipeSerializer.readLazyStack(buffer));
        }
        return new SawmillRecipe(output, stripped, input, energy, new TagOutputList(secondaryOutputs), new TagOutputList(strippingOutputs));
    }

    public void toNetwork(FriendlyByteBuf buffer, SawmillRecipe recipe) {
        SawmillRecipeSerializer.writeLazyStack(buffer, recipe.output);
        buffer.writeItem(recipe.stripped.get());
        recipe.input.toNetwork(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.secondaryStripping.get().size());
        for (ItemStack secondaryOutput : recipe.secondaryStripping.get()) {
            buffer.writeItem(secondaryOutput);
        }
        buffer.writeInt(recipe.secondaryOutputs.get().size());
        for (ItemStack secondaryOutput : recipe.secondaryOutputs.get()) {
            buffer.writeItem(secondaryOutput);
        }
    }
}

