/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class SqueezerRecipeSerializer
extends IERecipeSerializer<SqueezerRecipe> {
    public static final Codec<SqueezerRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SqueezerRecipeSerializer.optionalFluidOutput("fluid").forGetter(r -> r.fluidOutput), (App)SqueezerRecipeSerializer.optionalItemOutput("result").forGetter(r -> r.itemOutput), (App)IngredientWithSize.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Codec.INT.fieldOf("energy").forGetter(MultiblockRecipe::getBaseEnergy)).apply((Applicative)inst, SqueezerRecipe::new));

    public Codec<SqueezerRecipe> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.SQUEEZER.iconStack();
    }

    @Nullable
    public SqueezerRecipe fromNetwork(FriendlyByteBuf buffer) {
        FluidStack fluidOutput = buffer.readFluidStack();
        TagOutput itemOutput = SqueezerRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        int energy = buffer.readInt();
        return new SqueezerRecipe(fluidOutput, itemOutput, input, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, SqueezerRecipe recipe) {
        buffer.writeFluidStack(recipe.fluidOutput);
        buffer.writeItem(recipe.itemOutput.get());
        recipe.input.write(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

