/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.energy.ThermoelectricSource;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class ThermoelectricSourceSerializer
extends IERecipeSerializer<ThermoelectricSource> {
    public static final Codec<ThermoelectricSource> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("tempKelvin").forGetter(r -> r.temperature), (App)ExtraCodecs.strictOptionalField((Codec)TagKey.codec((ResourceKey)Registries.BLOCK), (String)"blockTag").forGetter(r -> r.blocks.leftOptional()), (App)ThermoelectricSourceSerializer.maybeListOrSingle(BuiltInRegistries.BLOCK.byNameCodec(), "singleBlock").forGetter(r -> r.blocks.rightOptional())).apply((Applicative)inst, (temperature, tag, fixedBlocks) -> {
        Preconditions.checkState((tag.isPresent() != fixedBlocks.isPresent() ? 1 : 0) != 0);
        if (tag.isPresent()) {
            return new ThermoelectricSource((TagKey<Block>)((TagKey)tag.get()), (int)temperature);
        }
        return new ThermoelectricSource((List)fixedBlocks.get(), (int)temperature);
    }));

    public Codec<ThermoelectricSource> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.MetalDevices.THERMOELECTRIC_GEN);
    }

    @Nullable
    public ThermoelectricSource fromNetwork(@Nonnull FriendlyByteBuf buffer) {
        List<Block> blocks = PacketUtils.readList(buffer, buf -> (Block)PacketUtils.readRegistryElement(buffer, BuiltInRegistries.BLOCK));
        int temperature = buffer.readInt();
        return new ThermoelectricSource(blocks, temperature);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull ThermoelectricSource recipe) {
        PacketUtils.writeList(buffer, recipe.getMatchingBlocks(), (b, buf) -> PacketUtils.writeRegistryElement(buf, BuiltInRegistries.BLOCK, b));
        buffer.writeInt(recipe.getTemperature());
    }
}

