/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.common.crafting.fluidaware.TurnAndCopyRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class TurnAndCopyRecipeSerializer
implements RecipeSerializer<TurnAndCopyRecipe> {
    private static final Codec<AdditionalData> ADDITIONAL_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.INT.listOf(), (String)"copyNBT", List.of()).forGetter(AdditionalData::copySlots), (App)ExtraCodecs.strictOptionalField((Codec)Codec.BOOL, (String)"quarter_turn", (Object)false).forGetter(AdditionalData::quarter), (App)ExtraCodecs.strictOptionalField((Codec)Codec.BOOL, (String)"eight_turn", (Object)false).forGetter(AdditionalData::eights), (App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"copy_nbt_predicate").forGetter(AdditionalData::predicate)).apply((Applicative)inst, AdditionalData::new));
    public static final Codec<TurnAndCopyRecipe> CODEC = Codec.pair((Codec)RecipeSerializer.SHAPED_RECIPE.codec(), ADDITIONAL_CODEC).xmap(p -> {
        AdditionalData extra = (AdditionalData)p.getSecond();
        TurnAndCopyRecipe result = new TurnAndCopyRecipe((ShapedRecipe)p.getFirst(), extra.copySlots());
        if (extra.quarter()) {
            result.allowQuarterTurn();
        }
        if (extra.eights()) {
            result.allowEighthTurn();
        }
        if (extra.predicate().isPresent()) {
            result.setNBTCopyPredicate(extra.predicate().get());
        }
        return result;
    }, r -> Pair.of((Object)r.toVanilla(), (Object)new AdditionalData((TurnAndCopyRecipe)r)));

    public Codec<TurnAndCopyRecipe> codec() {
        return CODEC;
    }

    public TurnAndCopyRecipe fromNetwork(@Nonnull FriendlyByteBuf buffer) {
        ShapedRecipe basic = (ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.fromNetwork(buffer);
        List copySlots = buffer.readList(FriendlyByteBuf::readVarInt);
        TurnAndCopyRecipe recipe = new TurnAndCopyRecipe(basic, copySlots);
        if (buffer.readBoolean()) {
            recipe.setNBTCopyPredicate(buffer.readUtf(512));
        }
        if (buffer.readBoolean()) {
            recipe.allowQuarterTurn();
        }
        if (buffer.readBoolean()) {
            recipe.allowEighthTurn();
        }
        return recipe;
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull TurnAndCopyRecipe recipe) {
        RecipeSerializer.SHAPED_RECIPE.toNetwork(buffer, (Recipe)recipe.toVanilla());
        buffer.writeCollection(recipe.getCopyTargets(), FriendlyByteBuf::writeVarInt);
        if (recipe.hasCopyPredicate()) {
            buffer.writeBoolean(true);
            buffer.writeUtf(recipe.getBufferPredicate());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeBoolean(recipe.isQuarterTurn());
        buffer.writeBoolean(recipe.isEightTurn());
    }

    private record AdditionalData(List<Integer> copySlots, boolean quarter, boolean eights, Optional<String> predicate) {
        public AdditionalData(TurnAndCopyRecipe recipe) {
            this(recipe.getCopyTargets(), recipe.isQuarterTurn(), recipe.isEightTurn(), Optional.ofNullable(recipe.getBufferPredicate()));
        }
    }
}

