/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.energy.WindmillBiome;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;

public class WindmillBiomeSerializer
extends IERecipeSerializer<WindmillBiome> {
    public static final Codec<WindmillBiome> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("modifier").forGetter(r -> Float.valueOf(r.modifier)), (App)ExtraCodecs.strictOptionalField((Codec)TagKey.codec((ResourceKey)Registries.BIOME), (String)"biomeTag").forGetter(r -> r.biomes.leftOptional()), (App)ExtraCodecs.strictOptionalField((Codec)ResourceKey.codec((ResourceKey)Registries.BIOME).listOf(), (String)"singleBiome").forGetter(r -> r.biomes.rightOptional())).apply((Applicative)inst, (temperature, tag, fixedBiomes) -> {
        Preconditions.checkState((tag.isPresent() != fixedBiomes.isPresent() ? 1 : 0) != 0);
        if (tag.isPresent()) {
            return new WindmillBiome((TagKey<Biome>)((TagKey)tag.get()), temperature.floatValue());
        }
        return new WindmillBiome((List)fixedBiomes.get(), temperature.floatValue());
    }));

    public Codec<WindmillBiome> codec() {
        return CODEC;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.WoodenDevices.WINDMILL);
    }

    @Nullable
    public WindmillBiome fromNetwork(@Nonnull FriendlyByteBuf buffer) {
        boolean isTags = buffer.readBoolean();
        if (isTags) {
            ResourceLocation tagName = buffer.readResourceLocation();
            TagKey tag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tagName);
            return new WindmillBiome((TagKey<Biome>)tag, buffer.readFloat());
        }
        List<ResourceKey<Biome>> biomes = PacketUtils.readList(buffer, buf -> buf.readResourceKey(Registries.BIOME));
        return new WindmillBiome(biomes, buffer.readFloat());
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull WindmillBiome recipe) {
        if (recipe.biomes.isLeft()) {
            buffer.writeBoolean(true);
            buffer.writeResourceLocation(recipe.biomes.leftNonnull().location());
        } else {
            buffer.writeBoolean(false);
            PacketUtils.writeList(buffer, recipe.biomes.rightNonnull(), (b, buf) -> buf.writeResourceKey(b));
        }
        buffer.writeFloat(recipe.getModifier());
    }
}

