/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class WrappingRecipeSerializer<WrappingType extends Recipe<?>, WrappedType extends Recipe<?>>
implements RecipeSerializer<WrappingType> {
    private final RecipeSerializer<WrappedType> inner;
    private final Function<WrappingType, WrappedType> unwrap;
    private final Function<WrappedType, WrappingType> wrap;
    private final Codec<WrappingType> codec;

    public WrappingRecipeSerializer(RecipeSerializer<WrappedType> inner, Function<WrappingType, WrappedType> unwrap, Function<WrappedType, WrappingType> wrap) {
        this.inner = inner;
        this.unwrap = unwrap;
        this.wrap = wrap;
        this.codec = inner.codec().xmap(wrap, unwrap);
    }

    public Codec<WrappingType> codec() {
        return this.codec;
    }

    @Nullable
    public WrappingType fromNetwork(@Nonnull FriendlyByteBuf buffer) {
        Recipe vanilla = this.inner.fromNetwork(buffer);
        if (vanilla != null) {
            return (WrappingType)((Recipe)this.wrap.apply(vanilla));
        }
        return null;
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull WrappingType recipe) {
        this.inner.toNetwork(buffer, (Recipe)this.unwrap.apply(recipe));
    }
}

