/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.blocks.wooden.WoodenBarrelBlockEntity;
import blusunrize.immersiveengineering.common.entities.IEMinecartEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BarrelMinecartEntity
extends IEMinecartEntity<WoodenBarrelBlockEntity> {
    public MinecartFluidHandler minecartFluidHandler = new MinecartFluidHandler(this);

    public BarrelMinecartEntity(Level world, double x, double y, double z) {
        this((EntityType)IEEntityTypes.BARREL_MINECART.get(), world, x, y, z);
    }

    public BarrelMinecartEntity(EntityType<?> type, Level world, double x, double y, double z) {
        super(type, world, x, y, z);
    }

    public BarrelMinecartEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public static <T extends BarrelMinecartEntity> void registerCapabilities(RegisterCapabilitiesEvent ev, Supplier<EntityType<T>> type) {
        ev.registerEntity(Capabilities.FluidHandler.ENTITY, type.get(), (e, $) -> e.minecartFluidHandler);
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)IEItems.Minecarts.CART_WOODEN_BARREL.get());
    }

    @Override
    public void writeTileToItem(ItemStack itemStack) {
        CompoundTag tag = new CompoundTag();
        ((WoodenBarrelBlockEntity)this.containedBlockEntity).writeTank(tag, true);
        if (!tag.isEmpty()) {
            itemStack.setTag(tag);
        }
    }

    @Override
    public void readTileFromItem(LivingEntity placer, ItemStack itemStack) {
        ((WoodenBarrelBlockEntity)this.containedBlockEntity).onBEPlaced(itemStack);
    }

    @Override
    @Nonnull
    public InteractionResult interact(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (super.interact(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        if (FluidUtil.getFluidHandler((ItemStack)itemstack).isPresent()) {
            ((WoodenBarrelBlockEntity)this.containedBlockEntity).interact(null, player, hand, itemstack, 0.0f, 0.0f, 0.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected Supplier<WoodenBarrelBlockEntity> getTileProvider() {
        return () -> new WoodenBarrelBlockEntity(BlockPos.ZERO, IEBlocks.WoodenDevices.WOODEN_BARREL.defaultBlockState());
    }

    public BlockState getDisplayBlockState() {
        return IEBlocks.WoodenDevices.WOODEN_BARREL.defaultBlockState();
    }

    static class MinecartFluidHandler
    implements IFluidHandler {
        final BarrelMinecartEntity minecart;

        public MinecartFluidHandler(BarrelMinecartEntity minecart) {
            this.minecart = minecart;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return ((WoodenBarrelBlockEntity)this.minecart.containedBlockEntity).tank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return ((WoodenBarrelBlockEntity)this.minecart.containedBlockEntity).tank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return ((WoodenBarrelBlockEntity)this.minecart.containedBlockEntity).tank.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int filled = ((WoodenBarrelBlockEntity)this.minecart.containedBlockEntity).tank.fill(resource, action);
            this.updateContainingEntity();
            return filled;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack drained = ((WoodenBarrelBlockEntity)this.minecart.containedBlockEntity).tank.drain(resource, action);
            this.updateContainingEntity();
            return drained;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack drained = ((WoodenBarrelBlockEntity)this.minecart.containedBlockEntity).tank.drain(maxDrain, action);
            this.updateContainingEntity();
            return drained;
        }

        private void updateContainingEntity() {
            this.minecart.updateSynchedData();
        }
    }
}

