/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.register.IEEntityDataSerializers;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import javax.annotation.Nonnull;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;

public class ChemthrowerShotEntity
extends IEProjectileEntity {
    @Nonnull
    private FluidStack fluid = FluidStack.EMPTY;
    private static final EntityDataAccessor<FluidStack> dataMarker_fluid = SynchedEntityData.defineId(ChemthrowerShotEntity.class, IEEntityDataSerializers.FLUID_STACK.get());

    public ChemthrowerShotEntity(EntityType<ChemthrowerShotEntity> type, Level world) {
        super(type, world);
    }

    public ChemthrowerShotEntity(Level world, double x, double y, double z, @Nonnull FluidStack fluid) {
        super((EntityType<? extends IEProjectileEntity>)((EntityType)IEEntityTypes.CHEMTHROWER_SHOT.get()), world, x, y, z);
        this.fluid = fluid;
        this.setFluidSynced();
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public ChemthrowerShotEntity(Level world, LivingEntity living, double ax, double ay, double az, @Nonnull FluidStack fluid) {
        super((EntityType<? extends IEProjectileEntity>)((EntityType)IEEntityTypes.CHEMTHROWER_SHOT.get()), world, living, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(dataMarker_fluid, (Object)FluidStack.EMPTY);
    }

    public void setFluidSynced() {
        this.entityData.set(dataMarker_fluid, (Object)this.getFluid());
    }

    @Nonnull
    public FluidStack getFluidSynced() {
        return (FluidStack)this.entityData.get(dataMarker_fluid);
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public double getGravity() {
        if (this.getFluid().isEmpty()) {
            return super.getGravity();
        }
        FluidStack fluidStack = this.getFluid();
        boolean isGas = fluidStack.getFluid().is(Tags.Fluids.GASEOUS);
        return (isGas ? 0.025f : 0.05f) * (float)(fluidStack.getFluid().getFluidType().getDensity(fluidStack) < 0 ? -1 : 1);
    }

    @Override
    public boolean canIgnite() {
        return ChemthrowerHandler.isFlammable(this.getFluid().getFluid());
    }

    public void baseTick() {
        if (this.level().isClientSide) {
            this.fluid = this.getFluidSynced();
        }
        BlockState state = this.level().getBlockState(this.blockPosition());
        if (this.canIgnite() && (state.is(BlockTags.FIRE) || state.getFluidState().is(FluidTags.LAVA))) {
            this.setSecondsOnFire(6);
        }
        super.baseTick();
    }

    public void setSecondsOnFire(int seconds) {
        if (!this.canIgnite()) {
            return;
        }
        super.setSecondsOnFire(seconds);
    }

    public void onHit(HitResult mop) {
        boolean fire;
        if (this.level().isClientSide || this.getFluid().isEmpty()) {
            return;
        }
        FluidStack fluidStack = this.getFluid();
        Fluid fluid = fluidStack.getFluid();
        ChemthrowerHandler.ChemthrowerEffect effect = ChemthrowerHandler.getEffect(fluid);
        boolean bl = fire = fluid.getFluidType().getTemperature(fluidStack) > 1000;
        if (effect != null) {
            ItemStack thrower = ItemStack.EMPTY;
            Player shooter = (Player)this.getOwner();
            if (shooter != null) {
                thrower = shooter.getItemInHand(InteractionHand.MAIN_HAND);
            }
            if (mop.getType() == HitResult.Type.ENTITY && ((EntityHitResult)mop).getEntity() instanceof LivingEntity) {
                effect.applyToEntity((LivingEntity)((EntityHitResult)mop).getEntity(), shooter, thrower, fluidStack);
            } else if (mop.getType() == HitResult.Type.BLOCK) {
                effect.applyToBlock(this.level(), mop, shooter, thrower, fluidStack);
            }
        } else if (mop.getType() == HitResult.Type.ENTITY && fluid.getFluidType().getTemperature(fluidStack) > 500) {
            int tempDiff = fluid.getFluidType().getTemperature(fluidStack) - 300;
            int damage = Math.abs(tempDiff) / 500;
            Entity hit = ((EntityHitResult)mop).getEntity();
            if (hit.hurt(hit.damageSources().lava(), (float)damage)) {
                hit.invulnerableTime = (int)((double)hit.invulnerableTime * 0.75);
            }
        }
        if (mop.getType() == HitResult.Type.ENTITY) {
            int f;
            int n = this.isOnFire() ? this.getRemainingFireTicks() : (f = fire ? 3 : 0);
            if (f > 0) {
                Entity hit = ((EntityHitResult)mop).getEntity();
                hit.setSecondsOnFire(f);
                if (hit.hurt(hit.damageSources().inFire(), 2.0f)) {
                    hit.invulnerableTime = (int)((double)hit.invulnerableTime * 0.75);
                }
            }
        }
    }

    public int getBrightnessForRender() {
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            int light = this.isOnFire() ? 15 : fluidStack.getFluid().getFluidType().getLightLevel(fluidStack);
            int superBrightness = 0;
            if ((light = superBrightness & 0xFF00000 | light << 4) > 0) {
                return light;
            }
        }
        return 0;
    }
}

