/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.blocks.wooden.WoodenCrateBlockEntity;
import blusunrize.immersiveengineering.common.entities.IEMinecartEntity;
import blusunrize.immersiveengineering.common.gui.CrateEntityContainer;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class CrateMinecartEntity
extends IEMinecartEntity<WoodenCrateBlockEntity> {
    public CrateMinecartEntity(Level world, double x, double y, double z) {
        this((EntityType)IEEntityTypes.CRATE_MINECART.get(), world, x, y, z);
    }

    public CrateMinecartEntity(EntityType<?> type, Level world, double x, double y, double z) {
        super(type, world, x, y, z);
    }

    public CrateMinecartEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public static <T extends CrateMinecartEntity> void registerCapabilities(RegisterCapabilitiesEvent ev, Supplier<EntityType<T>> type) {
        ev.registerEntity(Capabilities.ItemHandler.ENTITY_AUTOMATION, type.get(), (e, $) -> ((WoodenCrateBlockEntity)e.containedBlockEntity).getInventoryCap());
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)IEItems.Minecarts.CART_WOODEN_CRATE.get());
    }

    @Override
    public void writeTileToItem(ItemStack itemStack) {
        CompoundTag tag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)tag, ((WoodenCrateBlockEntity)this.containedBlockEntity).getInventory());
        if (!tag.isEmpty()) {
            itemStack.setTag(tag);
        }
    }

    @Override
    public void readTileFromItem(LivingEntity placer, ItemStack itemStack) {
        ((WoodenCrateBlockEntity)this.containedBlockEntity).onBEPlaced(itemStack);
    }

    @Override
    protected Supplier<WoodenCrateBlockEntity> getTileProvider() {
        return () -> new WoodenCrateBlockEntity(BlockPos.ZERO, IEBlocks.WoodenDevices.CRATE.defaultBlockState());
    }

    @Nonnull
    public BlockState getDisplayBlockState() {
        return IEBlocks.WoodenDevices.CRATE.defaultBlockState();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new CrateEntityContainer(IEMenuTypes.WOODEN_CRATE.get(), id, inv, this);
    }
}

