/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.util.DirectionalMiningExplosion;
import blusunrize.immersiveengineering.mixin.accessors.TNTEntityAccess;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;

public class GunpowderBarrelEntity
extends PrimedTnt {
    private float size;
    private Explosion.BlockInteraction mode = Explosion.BlockInteraction.DESTROY;
    private boolean isFlaming = false;
    public BlockState block;
    private Component name;
    private static final EntityDataAccessor<BlockState> dataMarker_block = SynchedEntityData.defineId(GunpowderBarrelEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private static final EntityDataAccessor<Integer> dataMarker_fuse = SynchedEntityData.defineId(GunpowderBarrelEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public GunpowderBarrelEntity(EntityType<GunpowderBarrelEntity> type, Level world) {
        super(type, world);
    }

    public GunpowderBarrelEntity(Level world, BlockPos pos, LivingEntity igniter, BlockState blockstate, float size) {
        super((EntityType)IEEntityTypes.EXPLOSIVE.get(), world);
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        this.setFuse(80);
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        ((TNTEntityAccess)((Object)this)).setOwner(igniter);
        this.size = size;
        this.block = blockstate;
        this.setBlockSynced();
    }

    public GunpowderBarrelEntity setMode(Explosion.BlockInteraction smoke) {
        this.mode = smoke;
        return this;
    }

    public GunpowderBarrelEntity setFlaming(boolean fire) {
        this.isFlaming = fire;
        return this;
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(dataMarker_block, (Object)Blocks.AIR.defaultBlockState());
        this.entityData.define(dataMarker_fuse, (Object)0);
    }

    private void setBlockSynced() {
        if (this.block != null) {
            this.entityData.set(dataMarker_block, (Object)this.block);
            this.entityData.set(dataMarker_fuse, (Object)this.getFuse());
        }
    }

    private void getBlockSynced() {
        this.block = (BlockState)this.entityData.get(dataMarker_block);
        if (this.block.isAir()) {
            this.block = null;
        }
        this.setFuse((Integer)this.entityData.get(dataMarker_fuse));
    }

    @Nonnull
    public Component getName() {
        ItemStack s;
        if (this.block != null && this.name == null && !(s = new ItemStack((ItemLike)this.block.getBlock(), 1)).isEmpty() && s.getItem() != Items.AIR) {
            this.name = s.getHoverName();
        }
        if (this.name != null) {
            return this.name;
        }
        return super.getName();
    }

    protected void addAdditionalSaveData(CompoundTag tagCompound) {
        super.addAdditionalSaveData(tagCompound);
        tagCompound.putFloat("explosionPower", this.size);
        tagCompound.putInt("explosionSmoke", this.mode.ordinal());
        tagCompound.putBoolean("explosionFire", this.isFlaming);
        if (this.block != null) {
            tagCompound.putInt("block", Block.getId((BlockState)this.block));
        }
    }

    protected void readAdditionalSaveData(CompoundTag tagCompound) {
        super.readAdditionalSaveData(tagCompound);
        this.size = tagCompound.getFloat("explosionPower");
        this.mode = Explosion.BlockInteraction.values()[tagCompound.getInt("explosionSmoke")];
        this.isFlaming = tagCompound.getBoolean("explosionFire");
        if (tagCompound.contains("block", 3)) {
            this.block = Block.stateById((int)tagCompound.getInt("block"));
        }
    }

    public void tick() {
        if (this.level().isClientSide && this.block == null) {
            this.getBlockSynced();
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        }
        int newFuse = this.getFuse() - 1;
        this.setFuse(newFuse);
        if (newFuse < 0) {
            DirectionalMiningExplosion explosion = new DirectionalMiningExplosion(this.level(), (Entity)this, this.getX(), this.getY(), this.getZ(), this.isFlaming);
            if (!EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion)) {
                if (!this.level().isClientSide()) {
                    explosion.explode();
                }
                explosion.finalizeExplosion(true);
            }
            this.discard();
        } else {
            this.updateInWaterStateAndDoFluidPushing();
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }
}

