/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public abstract class IEProjectileEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Optional<UUID>> SHOOTER_PARAMETER = SynchedEntityData.defineId(IEProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public int ticksInAir;
    protected IntSet piercedEntities;
    @Nullable
    protected UUID shooterUUID;
    private boolean forceNoGravity;
    private int tickLimit = 40;

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world) {
        super(type, world, ItemStack.EMPTY);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        this.setSoundEvent(SoundEvents.EMPTY);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, double x, double y, double z) {
        this(type, world);
        this.moveTo(x, y, z, this.getYRot(), this.getXRot());
        this.setPos(x, y, z);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, LivingEntity living, double ax, double ay, double az) {
        this(type, world, living, living.getX(), living.getY() + (double)living.getEyeHeight(), living.getZ(), ax, ay, az);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, @Nonnull LivingEntity living, float velocity, float inaccuracy) {
        this(type, world);
        this.setOwner((Entity)living);
        this.setShooterSynced();
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
        this.shootFromRotation((Entity)living, living.getXRot(), living.getYRot(), 0.0f, velocity, inaccuracy);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, LivingEntity living, double x, double y, double z, double ax, double ay, double az) {
        this(type, world);
        float yaw = living != null ? living.getYRot() : 0.0f;
        float pitch = living != null ? living.getXRot() : 0.0f;
        this.moveTo(x, y, z, yaw, pitch);
        this.setPos(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(ax, ay, az);
        this.setOwner((Entity)living);
        this.setShooterSynced();
        Vec3 motion = this.getDeltaMovement();
        this.shoot(motion.x, motion.y, motion.z, 3.0f, 1.0f);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(SHOOTER_PARAMETER, Optional.empty());
    }

    @Nonnull
    public EntityDimensions getDimensions(Pose poseIn) {
        return new EntityDimensions(0.125f, 0.125f, true);
    }

    public void setTickLimit(int limit) {
        this.tickLimit = limit;
    }

    public void setShooterSynced() {
        this.entityData.set(SHOOTER_PARAMETER, Optional.ofNullable(this.shooterUUID));
    }

    public UUID getShooterSynced() {
        Optional s = (Optional)this.entityData.get(SHOOTER_PARAMETER);
        return s.orElse(null);
    }

    @Nullable
    public UUID getShooterUUID() {
        return this.shooterUUID;
    }

    @Nonnull
    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    public boolean isInGround() {
        return this.inGround;
    }

    public void tick() {
        if (!this.isInGround()) {
            ++this.ticksInAir;
        }
        if (this.ticksInAir >= this.tickLimit || this.inGroundTime >= this.getMaxTicksInGround()) {
            this.discard();
        }
        if (this.getOwner() == null && this.level().isClientSide) {
            this.shooterUUID = this.getShooterSynced();
        }
        Vec3 delta = this.getDeltaMovement().add(0.0, 0.0, 0.0);
        float xRotPrev = this.getXRot();
        float yRotPrev = this.getYRot();
        float xRot0Prev = this.xRotO;
        float yRot0Prev = this.yRotO;
        this.forceNoGravity = true;
        super.tick();
        this.forceNoGravity = false;
        if (!this.isRemoved() && !this.inGround) {
            Vec3 vec32 = this.position();
            Vec3 vec33 = vec32.add(delta);
            BlockHitResult blockHitResult = this.level().clip(new ClipContext(vec32, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (blockHitResult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)blockHitResult)) {
                this.onHit((HitResult)blockHitResult);
                this.hasImpulse = true;
            }
        }
        if (!this.inGround) {
            this.setXRot(xRotPrev);
            this.setYRot(yRotPrev);
            this.xRotO = xRot0Prev;
            this.yRotO = yRot0Prev;
            float absMotion = (float)delta.length();
            this.setYRot((float)(Math.atan2(delta.x, delta.z) * 180.0 / Math.PI));
            this.setXRot((float)(Math.atan2(delta.y, absMotion) * 180.0 / Math.PI));
            while (this.getXRot() - this.xRotO < -180.0f) {
                this.xRotO -= 360.0f;
            }
            while (this.getXRot() - this.xRotO >= 180.0f) {
                this.xRotO += 360.0f;
            }
            while (this.getYRot() - this.yRotO < -180.0f) {
                this.yRotO -= 360.0f;
            }
            while (this.getYRot() - this.yRotO >= 180.0f) {
                this.yRotO += 360.0f;
            }
            this.setXRot(this.xRotO + (this.getXRot() - this.xRotO) * 0.2f);
            this.setYRot(this.yRotO + (this.getYRot() - this.yRotO) * 0.2f);
            float movementDecay = this.getMotionDecayFactor();
            if (this.isInWater()) {
                movementDecay *= 0.8f;
            }
            if (movementDecay > 0.0f) {
                this.setDeltaMovement(delta.scale((double)movementDecay).add(0.0, -this.getGravity(), 0.0));
            }
        }
    }

    public void playerTouch(Player player) {
        if (!this.level().isClientSide && (this.inGround || this.isNoPhysics()) && this.shakeTime <= 0) {
            boolean flag;
            boolean bl = flag = this.pickup == AbstractArrow.Pickup.ALLOWED || this.pickup == AbstractArrow.Pickup.CREATIVE_ONLY && player.getAbilities().instabuild || this.isNoPhysics() && this.getOwner().getUUID() == player.getUUID();
            if (this.pickup == AbstractArrow.Pickup.ALLOWED && !player.getInventory().add(this.getPickupItem())) {
                flag = false;
            }
            if (flag) {
                player.take((Entity)this, 1);
                this.discard();
            }
        }
    }

    protected void handlePiecing(Entity target) {
        if (this.getPierceLevel() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet((int)this.getPierceLevel());
            }
            if (this.piercedEntities.size() >= this.getPierceLevel() + 1) {
                this.discard();
                return;
            }
            this.piercedEntities.add(target.getId());
        } else {
            this.discard();
        }
    }

    public double getGravity() {
        return 0.05f;
    }

    public boolean canIgnite() {
        return false;
    }

    public int getMaxTicksInGround() {
        return 100;
    }

    protected float getMotionDecayFactor() {
        return 0.99f;
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (this.shooterUUID != null) {
            nbt.putUUID("Owner", this.shooterUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.shooterUUID = nbt.contains("Owner") ? nbt.getUUID("Owner") : null;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public void setOwner(@Nullable Entity entityIn) {
        super.setOwner(entityIn);
        if (entityIn != null) {
            this.shooterUUID = entityIn.getUUID();
        }
    }

    public boolean isNoGravity() {
        return this.forceNoGravity || super.isNoGravity();
    }
}

