/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.network.MessageBirthdayParty;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class RevolvershotEntity
extends IEProjectileEntity {
    private BulletHandler.IBullet bulletType;
    public boolean bulletElectro = false;
    public ItemStack bulletPotion = ItemStack.EMPTY;
    private float gravity;
    private float movementDecay;

    public RevolvershotEntity(EntityType<? extends RevolvershotEntity> type, Level world) {
        super(type, world);
    }

    public RevolvershotEntity(EntityType<? extends RevolvershotEntity> eType, Level world, LivingEntity shooter, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super(eType, world, shooter, x, y, z, ax, ay, az);
        this.setPos(x, y, z);
        this.bulletType = type;
    }

    public RevolvershotEntity(Level world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        this((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.REVOLVERSHOT.get()), world, null, x, y, z, ax, ay, az, type);
    }

    public RevolvershotEntity(Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type) {
        this((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.REVOLVERSHOT.get()), world, living, ax, ay, az, type);
    }

    public RevolvershotEntity(EntityType<? extends RevolvershotEntity> eType, Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type) {
        this(eType, world, living, living.getX() + ax, living.getY() + (double)living.getEyeHeight() + ay, living.getZ() + az, ax, ay, az, type);
        this.setShooterSynced();
        this.setDeltaMovement(Vec3.ZERO);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.getBoundingBox().getSize() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public void onHit(HitResult mop) {
        Entity hitEntity;
        boolean headshot = false;
        if (mop instanceof EntityHitResult && (hitEntity = ((EntityHitResult)mop).getEntity()) instanceof LivingEntity) {
            headshot = Utils.isVecInEntityHead((LivingEntity)hitEntity, this.position());
        }
        if (this.bulletType != null) {
            this.bulletType.onHitTarget(this.level(), mop, this.shooterUUID, (Entity)this, headshot);
            if (mop instanceof EntityHitResult) {
                hitEntity = ((EntityHitResult)mop).getEntity();
                if (this.shooterUUID != null && headshot && hitEntity instanceof LivingEntity && ((LivingEntity)hitEntity).isBaby() && ((LivingEntity)hitEntity).getHealth() <= 0.0f) {
                    Player shooter = this.level().getPlayerByUUID(this.shooterUUID);
                    if (shooter != null) {
                        Utils.unlockIEAdvancement(shooter, "tools/secret_birthdayparty");
                    }
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)IESounds.birthdayParty.value(), SoundSource.PLAYERS, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                    PacketDistributor.TRACKING_ENTITY.with((Object)hitEntity).send(new CustomPacketPayload[]{new MessageBirthdayParty((LivingEntity)hitEntity)});
                }
            }
        }
        if (!this.level().isClientSide) {
            this.secondaryImpact(mop);
        }
        if (mop instanceof BlockHitResult) {
            this.onHitBlock((BlockHitResult)mop);
        }
        this.discard();
    }

    public void secondaryImpact(HitResult mop) {
        if (!(mop instanceof EntityHitResult)) {
            return;
        }
        Entity hitEntity = ((EntityHitResult)mop).getEntity();
        if (this.bulletElectro && hitEntity instanceof LivingEntity && this.shooterUUID != null) {
            Player shooter = this.level().getPlayerByUUID(this.shooterUUID);
            float percentualDrain = 0.15f / (float)(this.bulletType == null ? 1 : this.bulletType.getProjectileCount(shooter));
            ((LivingEntity)hitEntity).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 15, 4));
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                int actualDrain;
                ItemStack stack = ((LivingEntity)hitEntity).getItemBySlot(slot);
                if (!EnergyHelper.isFluxReceiver(stack) || EnergyHelper.getEnergyStored(stack) <= 0) continue;
                int drain = (int)Math.max((float)EnergyHelper.getEnergyStored(stack), (float)EnergyHelper.getMaxEnergyStored(stack) * percentualDrain);
                for (int hasDrained = 0; hasDrained < drain && (actualDrain = EnergyHelper.forceExtractFlux(stack, drain, false)) > 0; hasDrained += actualDrain) {
                }
            }
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putByte("inGround", (byte)(this.inGround ? 1 : 0));
        nbt.putString("bulletType", BulletHandler.findRegistryName(this.bulletType).toString());
        if (!this.bulletPotion.isEmpty()) {
            nbt.put("bulletPotion", (Tag)this.bulletPotion.save(new CompoundTag()));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.bulletType = BulletHandler.getBullet(new ResourceLocation(nbt.getString("bulletType")));
        if (nbt.contains("bulletPotion", 10)) {
            this.bulletPotion = ItemStack.of((CompoundTag)nbt.getCompound("bulletPotion"));
        }
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean isPickable() {
        return false;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    @Override
    public double getGravity() {
        return this.gravity;
    }

    public void setMovementDecay(float movementDecay) {
        this.movementDecay = movementDecay;
    }

    @Override
    protected float getMotionDecayFactor() {
        return this.movementDecay;
    }
}

