/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class RevolvershotFlareEntity
extends RevolvershotEntity {
    public int colour = -1;
    private static final EntityDataAccessor<Integer> dataMarker_colour = SynchedEntityData.defineId(RevolvershotFlareEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private BlockPos lightPos;

    public RevolvershotFlareEntity(EntityType<RevolvershotFlareEntity> type, Level world) {
        super((EntityType<? extends RevolvershotEntity>)type, world);
        this.setTickLimit(400);
    }

    public RevolvershotFlareEntity(Level world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.FLARE_REVOLVERSHOT.get()), world, null, x, y, z, ax, ay, az, type);
        this.setTickLimit(400);
    }

    public RevolvershotFlareEntity(Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type, ItemStack stack) {
        super((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.FLARE_REVOLVERSHOT.get()), world, living, ax, ay, az, type);
        this.setTickLimit(400);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(dataMarker_colour, (Object)-1);
    }

    public void setColourSynced() {
        this.entityData.set(dataMarker_colour, (Object)this.colour);
    }

    public int getColourSynced() {
        return (Integer)this.entityData.get(dataMarker_colour);
    }

    public int getColour() {
        return this.colour;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.colour < 0) {
            this.colour = this.getColourSynced();
        }
        if (this.level().isClientSide) {
            float r = (float)(this.getColour() >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.getColour() >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.getColour() & 0xFF) / 255.0f;
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 1.0f), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            if (this.tickCount > 40) {
                for (int i = 0; i < 20; ++i) {
                    Vec3 v = new Vec3(ApiUtils.RANDOM.nextDouble() - 0.5, ApiUtils.RANDOM.nextDouble() - 0.5, ApiUtils.RANDOM.nextDouble() - 0.5);
                    this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 1.0f), this.getX() + v.x, this.getY() + v.y, this.getZ() + v.z, v.x / 10.0, v.y / 10.0, v.z / 10.0);
                }
            }
        }
        if (this.tickCount == 40) {
            this.setDeltaMovement(0.0, -0.1, 0.0);
            this.spawnParticles();
            this.lightPos = this.blockPosition();
            for (int i = 0; i < 128; ++i) {
                if (!this.level().isEmptyBlock(this.lightPos)) {
                    this.lightPos = this.lightPos.above(6);
                    break;
                }
                this.lightPos = this.lightPos.below();
            }
        }
    }

    @Override
    public void onHit(HitResult mop) {
        if (this.tickCount <= 40) {
            if (!this.level().isClientSide) {
                if (mop instanceof EntityHitResult) {
                    Entity hit = ((EntityHitResult)mop).getEntity();
                    if (!hit.fireImmune()) {
                        hit.setSecondsOnFire(8);
                    }
                } else if (mop instanceof BlockHitResult) {
                    BlockHitResult blockRTR = (BlockHitResult)mop;
                    BlockPos pos = blockRTR.getBlockPos().relative(blockRTR.getDirection());
                    if (this.level().isEmptyBlock(pos)) {
                        this.level().setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                    }
                }
            }
            this.spawnParticles();
        }
        this.discard();
    }

    private void spawnParticles() {
        float r = (float)(this.getColour() >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.getColour() >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.getColour() & 0xFF) / 255.0f;
        for (int i = 0; i < 80; ++i) {
            Vec3 v = new Vec3((ApiUtils.RANDOM.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (ApiUtils.RANDOM.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (ApiUtils.RANDOM.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0);
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 1.0f), this.getX() + v.x, this.getY() + v.y, this.getZ() + v.z, v.x / 10.0, v.y / 10.0, v.z / 10.0);
        }
    }
}

