/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RevolvershotHomingEntity
extends RevolvershotEntity {
    public int trackCountdown = 5;
    public double redirectionSpeed = 0.25;
    public LivingEntity targetOverride;

    public RevolvershotHomingEntity(EntityType<? extends RevolvershotHomingEntity> type, Level world) {
        super((EntityType<? extends RevolvershotEntity>)type, world);
    }

    public RevolvershotHomingEntity(EntityType<? extends RevolvershotHomingEntity> eType, Level world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super(eType, world, null, x, y, z, ax, ay, az, type);
    }

    public RevolvershotHomingEntity(Level world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        this((EntityType<? extends RevolvershotHomingEntity>)((EntityType)IEEntityTypes.HOMING_REVOLVERSHOT.get()), world, x, y, z, ax, ay, az, type);
    }

    public RevolvershotHomingEntity(Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type) {
        super((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.HOMING_REVOLVERSHOT.get()), world, living, ax, ay, az, type);
    }

    public RevolvershotHomingEntity(EntityType<? extends RevolvershotHomingEntity> type, Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type1) {
        super(type, world, living, ax, ay, az, type1);
    }

    @Override
    public void tick() {
        LivingEntity target;
        super.tick();
        if (!this.level().isClientSide && this.tickCount > this.trackCountdown && (target = this.getTarget()) != null) {
            Vec3 oldMotion = this.getDeltaMovement();
            Vec3 newMotion = new Vec3(oldMotion.x * (1.0 - this.redirectionSpeed) + (target.getX() - this.getX()) * this.redirectionSpeed, oldMotion.y * (1.0 - this.redirectionSpeed) + (target.getY() + (double)(target.getBbHeight() / 2.0f) - this.getY()) * this.redirectionSpeed, oldMotion.z * (1.0 - this.redirectionSpeed) + (target.getZ() - this.getZ()) * this.redirectionSpeed).normalize();
            this.setDeltaMovement(newMotion);
        }
    }

    public LivingEntity getTarget() {
        if (this.targetOverride != null && this.targetOverride.isAlive()) {
            return this.targetOverride;
        }
        double r = 20.0;
        AABB aabb = new AABB(this.getX() - r, this.getY() - r, this.getZ() - r, this.getX() + r, this.getY() + r, this.getZ() + r);
        LivingEntity target = null;
        for (Object o : this.level().getEntitiesOfClass(LivingEntity.class, aabb)) {
            if (!(o instanceof LivingEntity) || ((LivingEntity)o).getUUID().equals(this.shooterUUID) || target != null && !(((LivingEntity)o).distanceToSqr((Entity)this) < target.distanceToSqr((Entity)this))) continue;
            target = (LivingEntity)o;
        }
        return target;
    }
}

