/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.RevolvershotHomingEntity;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class WolfpackShotEntity
extends RevolvershotHomingEntity {
    public WolfpackShotEntity(EntityType<WolfpackShotEntity> type, Level world) {
        super((EntityType<? extends RevolvershotHomingEntity>)type, world);
        this.trackCountdown = 15;
        this.redirectionSpeed = 0.1875;
    }

    public WolfpackShotEntity(Level world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super((EntityType<? extends RevolvershotHomingEntity>)((EntityType)IEEntityTypes.WOLFPACK_SHOT.get()), world, x, y, z, ax, ay, az, type);
        this.trackCountdown = 15;
        this.redirectionSpeed = 0.1875;
    }

    public WolfpackShotEntity(Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type) {
        super((EntityType<? extends RevolvershotHomingEntity>)((EntityType)IEEntityTypes.WOLFPACK_SHOT.get()), world, living, ax, ay, az, type);
        this.trackCountdown = 15;
        this.redirectionSpeed = 0.1875;
    }

    @Override
    public void onHit(HitResult mop) {
        if (!this.level().isClientSide && mop instanceof EntityHitResult) {
            Entity hit = ((EntityHitResult)mop).getEntity();
            if (hit.invulnerableTime > 0) {
                hit.invulnerableTime = 0;
            }
            Player shooter = this.shooterUUID != null ? this.level().getPlayerByUUID(this.shooterUUID) : null;
            hit.hurt(IEDamageSources.causeWolfpackDamage(this, (Entity)shooter), ((Double)IEServerConfig.TOOLS.bulletDamage_WolfpackPart.get()).floatValue());
        }
        this.discard();
    }
}

