/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities.illager;

import blusunrize.immersiveengineering.common.entities.ai.ShieldCombatGoal;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.level.Level;

public abstract class EngineerIllager
extends AbstractIllager {
    protected EngineerIllager(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isAlliedTo(Entity entity) {
        if (super.isAlliedTo(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).getMobType() == MobType.ILLAGER) {
            return this.getTeam() == null && entity.getTeam() == null;
        }
        return false;
    }

    protected float getEquipmentDropChance(EquipmentSlot slot) {
        return 0.0f;
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        return this.isCelebrating() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    protected void blockUsingShield(LivingEntity entity) {
        super.blockUsingShield(entity);
        if (entity.getMainHandItem().canDisableShield(this.useItem, (LivingEntity)this, entity)) {
            this.disableShield();
        }
    }

    public void disableShield() {
        for (WrappedGoal goal : this.goalSelector.getAvailableGoals()) {
            Goal goal2 = goal.getGoal();
            if (!(goal2 instanceof ShieldCombatGoal)) continue;
            ShieldCombatGoal shieldGoal = (ShieldCombatGoal)goal2;
            shieldGoal.disableShield();
        }
    }
}

