/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.fluids.IEFluid;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.mixin.accessors.FlowingFluidAccess;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ConcreteFluid
extends IEFluid {
    boolean hasFlownInTick = false;

    public ConcreteFluid(IEFluids.FluidEntry entry) {
        super(entry);
    }

    protected boolean isRandomlyTicking() {
        return true;
    }

    @Override
    public int getTickDelay(LevelReader p_205569_1_) {
        return 20;
    }

    public void tick(Level world, BlockPos pos, FluidState state) {
        boolean mayDry;
        this.hasFlownInTick = false;
        super.tick(world, pos, state);
        int timer = (Integer)state.getValue((Property)IEProperties.INT_32);
        int level = ConcreteFluid.getLegacyLevel((FluidState)state);
        int quantaRemaining = 16 - level;
        boolean bl = mayDry = timer >= 31;
        if (this.isSource(state)) {
            for (Direction neighborSide : Direction.Plane.HORIZONTAL) {
                if (!world.getBlockState(pos.relative(neighborSide)).getFluidState().getType().isSame((Fluid)this)) continue;
                mayDry = false;
            }
        }
        if (mayDry) {
            IEBlocks.BlockEntry<IEBaseBlock> solidBlock = level >= 5 && level < 8 ? IEBlocks.TO_SLAB.get(IEBlocks.StoneDecoration.CONCRETE.getId()) : IEBlocks.StoneDecoration.CONCRETE;
            world.setBlockAndUpdate(pos, solidBlock.get().defaultBlockState());
            for (LivingEntity living : world.getEntitiesOfClass(LivingEntity.class, new AABB(Vec3.ZERO, new Vec3(1.0, 1.0, 1.0)).move(pos))) {
                living.addEffect(new MobEffectInstance((MobEffect)IEPotions.CONCRETE_FEET.value(), Integer.MAX_VALUE));
            }
        } else if (world.getBlockState(pos).getBlock() == this.entry.getBlock()) {
            BlockState newState = (BlockState)world.getBlockState(pos).setValue((Property)IEProperties.INT_32, (Comparable)Integer.valueOf(Math.min(timer + 1, 31)));
            world.setBlockAndUpdate(pos, newState);
        }
    }

    @Nonnull
    protected FluidState getNewLiquid(Level worldIn, BlockPos pos, @Nonnull BlockState blockStateIn) {
        int maxNeighborLevel = 0;
        int correspondingTimer = 0;
        for (Direction neighborSide : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.relative(neighborSide);
            BlockState neighborState = worldIn.getBlockState(neighborPos);
            FluidState fluidAtNeighbor = neighborState.getFluidState();
            if (!fluidAtNeighbor.getType().isSame((Fluid)this) || !((FlowingFluidAccess)((Object)this)).callCanPassThroughWall(neighborSide, (BlockGetter)worldIn, pos, blockStateIn, neighborPos, neighborState)) continue;
            maxNeighborLevel = Math.max(maxNeighborLevel, fluidAtNeighbor.getAmount());
            correspondingTimer = Math.max(correspondingTimer, (Integer)fluidAtNeighbor.getValue((Property)IEProperties.INT_32));
        }
        correspondingTimer = Math.min(correspondingTimer + 1, 31);
        BlockPos abovePos = pos.above();
        BlockState aboveState = worldIn.getBlockState(abovePos);
        FluidState aboveFluid = aboveState.getFluidState();
        FluidState currFluid = blockStateIn.getFluidState();
        if (!aboveFluid.isEmpty() && aboveFluid.getType().isSame((Fluid)this) && ((FlowingFluidAccess)((Object)this)).callCanPassThroughWall(Direction.UP, (BlockGetter)worldIn, pos, blockStateIn, abovePos, aboveState)) {
            return this.getFlowingFluidState(8, true, currFluid, Math.max(correspondingTimer, (Integer)aboveFluid.getValue((Property)IEProperties.INT_32)));
        }
        int newLevel = maxNeighborLevel - this.getDropOff((LevelReader)worldIn);
        if (newLevel <= 0) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return this.getFlowingFluidState(newLevel, false, currFluid, correspondingTimer);
    }

    public FluidState getFlowingFluidState(int level, boolean falling, FluidState currentState, int baseDecay) {
        FluidState baseState = super.getFlowing(level, falling);
        if (this.isSame(currentState.getType())) {
            baseDecay = Math.max((Integer)currentState.getValue((Property)IEProperties.INT_32), baseDecay);
        }
        baseState = (FluidState)baseState.setValue((Property)IEProperties.INT_32, (Comparable)Integer.valueOf(baseDecay));
        return baseState;
    }

    protected void spreadTo(@Nonnull LevelAccessor worldIn, @Nonnull BlockPos pos, BlockState blockStateIn, Direction direction, @Nonnull FluidState fluidStateIn) {
        if (blockStateIn.getBlock() instanceof LiquidBlockContainer) {
            ((LiquidBlockContainer)blockStateIn.getBlock()).placeLiquid(worldIn, pos, blockStateIn, fluidStateIn);
        } else {
            if (!blockStateIn.isAir()) {
                this.beforeDestroyingBlock(worldIn, pos, blockStateIn);
            }
            worldIn.setBlock(pos, fluidStateIn.createLegacyBlock(), 3);
        }
        this.hasFlownInTick = true;
    }

    public static class Flowing
    extends ConcreteFluid {
        public Flowing(IEFluids.FluidEntry entry) {
            super(entry);
            this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        @Override
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }
    }
}

